package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.Policy
import scala.jdk.CollectionConverters.*
final case class ProposedMultiRegionAccessPointPolicy(
    policy: Option[Policy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.ProposedMultiRegionAccessPointPolicy = {
    import ProposedMultiRegionAccessPointPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.ProposedMultiRegionAccessPointPolicy
      .builder()
      .optionallyWith(
        policy.map(value => Policy.unwrap(value): java.lang.String)
      )(_.policy)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.ProposedMultiRegionAccessPointPolicy.ReadOnly =
    zio.aws.s3control.model.ProposedMultiRegionAccessPointPolicy
      .wrap(buildAwsValue())
}
object ProposedMultiRegionAccessPointPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.ProposedMultiRegionAccessPointPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.ProposedMultiRegionAccessPointPolicy =
      zio.aws.s3control.model
        .ProposedMultiRegionAccessPointPolicy(policy.map(value => value))
    def policy: Option[Policy]
    def getPolicy: ZIO[Any, AwsError, Policy] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.ProposedMultiRegionAccessPointPolicy
  ) extends zio.aws.s3control.model.ProposedMultiRegionAccessPointPolicy.ReadOnly {
    override val policy: Option[Policy] = scala
      .Option(impl.policy())
      .map(value => zio.aws.s3control.model.primitives.Policy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.ProposedMultiRegionAccessPointPolicy
  ): zio.aws.s3control.model.ProposedMultiRegionAccessPointPolicy.ReadOnly =
    new Wrapper(impl)
}
