package zio.aws.s3control.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.Days
import scala.jdk.CollectionConverters.*
final case class NoncurrentVersionTransition(
    noncurrentDays: Option[Days] = None,
    storageClass: Option[zio.aws.s3control.model.TransitionStorageClass] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.NoncurrentVersionTransition = {
    import NoncurrentVersionTransition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.NoncurrentVersionTransition
      .builder()
      .optionallyWith(noncurrentDays.map(value => Days.unwrap(value): Integer))(
        _.noncurrentDays
      )
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.NoncurrentVersionTransition.ReadOnly =
    zio.aws.s3control.model.NoncurrentVersionTransition.wrap(buildAwsValue())
}
object NoncurrentVersionTransition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.NoncurrentVersionTransition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.NoncurrentVersionTransition =
      zio.aws.s3control.model.NoncurrentVersionTransition(
        noncurrentDays.map(value => value),
        storageClass.map(value => value)
      )
    def noncurrentDays: Option[Days]
    def storageClass: Option[zio.aws.s3control.model.TransitionStorageClass]
    def getNoncurrentDays: ZIO[Any, AwsError, Days] =
      AwsError.unwrapOptionField("noncurrentDays", noncurrentDays)
    def getStorageClass
        : ZIO[Any, AwsError, zio.aws.s3control.model.TransitionStorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.NoncurrentVersionTransition
  ) extends zio.aws.s3control.model.NoncurrentVersionTransition.ReadOnly {
    override val noncurrentDays: Option[Days] = scala
      .Option(impl.noncurrentDays())
      .map(value => zio.aws.s3control.model.primitives.Days(value))
    override val storageClass
        : Option[zio.aws.s3control.model.TransitionStorageClass] = scala
      .Option(impl.storageClass())
      .map(value => zio.aws.s3control.model.TransitionStorageClass.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.NoncurrentVersionTransition
  ): zio.aws.s3control.model.NoncurrentVersionTransition.ReadOnly = new Wrapper(
    impl
  )
}
