package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MultiRegionAccessPointsAsyncResponse(
    regions: Option[
      Iterable[zio.aws.s3control.model.MultiRegionAccessPointRegionalResponse]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointsAsyncResponse = {
    import MultiRegionAccessPointsAsyncResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointsAsyncResponse
      .builder()
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.regions)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.MultiRegionAccessPointsAsyncResponse.ReadOnly =
    zio.aws.s3control.model.MultiRegionAccessPointsAsyncResponse
      .wrap(buildAwsValue())
}
object MultiRegionAccessPointsAsyncResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointsAsyncResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.MultiRegionAccessPointsAsyncResponse =
      zio.aws.s3control.model.MultiRegionAccessPointsAsyncResponse(
        regions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def regions: Option[List[
      zio.aws.s3control.model.MultiRegionAccessPointRegionalResponse.ReadOnly
    ]]
    def getRegions: ZIO[Any, AwsError, List[
      zio.aws.s3control.model.MultiRegionAccessPointRegionalResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("regions", regions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointsAsyncResponse
  ) extends zio.aws.s3control.model.MultiRegionAccessPointsAsyncResponse.ReadOnly {
    override val regions: Option[List[
      zio.aws.s3control.model.MultiRegionAccessPointRegionalResponse.ReadOnly
    ]] = scala
      .Option(impl.regions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3control.model.MultiRegionAccessPointRegionalResponse
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointsAsyncResponse
  ): zio.aws.s3control.model.MultiRegionAccessPointsAsyncResponse.ReadOnly =
    new Wrapper(impl)
}
