package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.s3control.model.primitives.{
  CreationTimestamp,
  MultiRegionAccessPointAlias,
  MultiRegionAccessPointName
}
import scala.jdk.CollectionConverters.*
final case class MultiRegionAccessPointReport(
    name: Option[MultiRegionAccessPointName] = None,
    alias: Option[MultiRegionAccessPointAlias] = None,
    createdAt: Option[CreationTimestamp] = None,
    publicAccessBlock: Option[
      zio.aws.s3control.model.PublicAccessBlockConfiguration
    ] = None,
    status: Option[zio.aws.s3control.model.MultiRegionAccessPointStatus] = None,
    regions: Option[Iterable[zio.aws.s3control.model.RegionReport]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointReport = {
    import MultiRegionAccessPointReport.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointReport
      .builder()
      .optionallyWith(
        name.map(value =>
          MultiRegionAccessPointName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        alias.map(value =>
          MultiRegionAccessPointAlias.unwrap(value): java.lang.String
        )
      )(_.alias)
      .optionallyWith(
        createdAt.map(value => CreationTimestamp.unwrap(value): Instant)
      )(_.createdAt)
      .optionallyWith(publicAccessBlock.map(value => value.buildAwsValue()))(
        _.publicAccessBlock
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.regions)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.MultiRegionAccessPointReport.ReadOnly =
    zio.aws.s3control.model.MultiRegionAccessPointReport.wrap(buildAwsValue())
}
object MultiRegionAccessPointReport {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointReport
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.MultiRegionAccessPointReport =
      zio.aws.s3control.model.MultiRegionAccessPointReport(
        name.map(value => value),
        alias.map(value => value),
        createdAt.map(value => value),
        publicAccessBlock.map(value => value.asEditable),
        status.map(value => value),
        regions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Option[MultiRegionAccessPointName]
    def alias: Option[MultiRegionAccessPointAlias]
    def createdAt: Option[CreationTimestamp]
    def publicAccessBlock: Option[
      zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly
    ]
    def status: Option[zio.aws.s3control.model.MultiRegionAccessPointStatus]
    def regions: Option[List[zio.aws.s3control.model.RegionReport.ReadOnly]]
    def getName: ZIO[Any, AwsError, MultiRegionAccessPointName] =
      AwsError.unwrapOptionField("name", name)
    def getAlias: ZIO[Any, AwsError, MultiRegionAccessPointAlias] =
      AwsError.unwrapOptionField("alias", alias)
    def getCreatedAt: ZIO[Any, AwsError, CreationTimestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getPublicAccessBlock: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("publicAccessBlock", publicAccessBlock)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.MultiRegionAccessPointStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getRegions: ZIO[Any, AwsError, List[
      zio.aws.s3control.model.RegionReport.ReadOnly
    ]] = AwsError.unwrapOptionField("regions", regions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointReport
  ) extends zio.aws.s3control.model.MultiRegionAccessPointReport.ReadOnly {
    override val name: Option[MultiRegionAccessPointName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.s3control.model.primitives.MultiRegionAccessPointName(value)
      )
    override val alias: Option[MultiRegionAccessPointAlias] = scala
      .Option(impl.alias())
      .map(value =>
        zio.aws.s3control.model.primitives.MultiRegionAccessPointAlias(value)
      )
    override val createdAt: Option[CreationTimestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.s3control.model.primitives.CreationTimestamp(value))
    override val publicAccessBlock: Option[
      zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly
    ] = scala
      .Option(impl.publicAccessBlock())
      .map(value =>
        zio.aws.s3control.model.PublicAccessBlockConfiguration.wrap(value)
      )
    override val status
        : Option[zio.aws.s3control.model.MultiRegionAccessPointStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.s3control.model.MultiRegionAccessPointStatus.wrap(value)
      )
    override val regions
        : Option[List[zio.aws.s3control.model.RegionReport.ReadOnly]] = scala
      .Option(impl.regions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3control.model.RegionReport.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointReport
  ): zio.aws.s3control.model.MultiRegionAccessPointReport.ReadOnly =
    new Wrapper(impl)
}
