package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.NonEmptyMaxLength1024String
import scala.jdk.CollectionConverters.*
final case class ListRegionalBucketsResponse(
    regionalBucketList: Option[
      Iterable[zio.aws.s3control.model.RegionalBucket]
    ] = None,
    nextToken: Option[NonEmptyMaxLength1024String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.ListRegionalBucketsResponse = {
    import ListRegionalBucketsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.ListRegionalBucketsResponse
      .builder()
      .optionallyWith(
        regionalBucketList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.regionalBucketList)
      .optionallyWith(
        nextToken.map(value =>
          NonEmptyMaxLength1024String.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.ListRegionalBucketsResponse.ReadOnly =
    zio.aws.s3control.model.ListRegionalBucketsResponse.wrap(buildAwsValue())
}
object ListRegionalBucketsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.ListRegionalBucketsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.ListRegionalBucketsResponse =
      zio.aws.s3control.model.ListRegionalBucketsResponse(
        regionalBucketList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def regionalBucketList
        : Option[List[zio.aws.s3control.model.RegionalBucket.ReadOnly]]
    def nextToken: Option[NonEmptyMaxLength1024String]
    def getRegionalBucketList: ZIO[Any, AwsError, List[
      zio.aws.s3control.model.RegionalBucket.ReadOnly
    ]] = AwsError.unwrapOptionField("regionalBucketList", regionalBucketList)
    def getNextToken: ZIO[Any, AwsError, NonEmptyMaxLength1024String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.ListRegionalBucketsResponse
  ) extends zio.aws.s3control.model.ListRegionalBucketsResponse.ReadOnly {
    override val regionalBucketList
        : Option[List[zio.aws.s3control.model.RegionalBucket.ReadOnly]] = scala
      .Option(impl.regionalBucketList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3control.model.RegionalBucket.wrap(item)
        }.toList
      )
    override val nextToken: Option[NonEmptyMaxLength1024String] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.s3control.model.primitives.NonEmptyMaxLength1024String(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.ListRegionalBucketsResponse
  ): zio.aws.s3control.model.ListRegionalBucketsResponse.ReadOnly = new Wrapper(
    impl
  )
}
