package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.StringForNextToken
import scala.jdk.CollectionConverters.*
final case class ListJobsResponse(
    nextToken: Option[StringForNextToken] = None,
    jobs: Option[Iterable[zio.aws.s3control.model.JobListDescriptor]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.ListJobsResponse = {
    import ListJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.ListJobsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value =>
          StringForNextToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        jobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.jobs)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.ListJobsResponse.ReadOnly =
    zio.aws.s3control.model.ListJobsResponse.wrap(buildAwsValue())
}
object ListJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.ListJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.ListJobsResponse =
      zio.aws.s3control.model.ListJobsResponse(
        nextToken.map(value => value),
        jobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[StringForNextToken]
    def jobs: Option[List[zio.aws.s3control.model.JobListDescriptor.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, StringForNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getJobs: ZIO[Any, AwsError, List[
      zio.aws.s3control.model.JobListDescriptor.ReadOnly
    ]] = AwsError.unwrapOptionField("jobs", jobs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.ListJobsResponse
  ) extends zio.aws.s3control.model.ListJobsResponse.ReadOnly {
    override val nextToken: Option[StringForNextToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.s3control.model.primitives.StringForNextToken(value)
      )
    override val jobs
        : Option[List[zio.aws.s3control.model.JobListDescriptor.ReadOnly]] =
      scala
        .Option(impl.jobs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3control.model.JobListDescriptor.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.ListJobsResponse
  ): zio.aws.s3control.model.ListJobsResponse.ReadOnly = new Wrapper(impl)
}
