package zio.aws.s3control.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.{
  MaxResults,
  NonEmptyMaxLength1024String,
  BucketName,
  AccountId
}
import scala.jdk.CollectionConverters.*
final case class ListAccessPointsRequest(
    accountId: AccountId,
    bucket: Option[BucketName] = None,
    nextToken: Option[NonEmptyMaxLength1024String] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.ListAccessPointsRequest = {
    import ListAccessPointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.ListAccessPointsRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .optionallyWith(
        bucket.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        nextToken.map(value =>
          NonEmptyMaxLength1024String.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.ListAccessPointsRequest.ReadOnly =
    zio.aws.s3control.model.ListAccessPointsRequest.wrap(buildAwsValue())
}
object ListAccessPointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.ListAccessPointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.ListAccessPointsRequest =
      zio.aws.s3control.model.ListAccessPointsRequest(
        accountId,
        bucket.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def accountId: AccountId
    def bucket: Option[BucketName]
    def nextToken: Option[NonEmptyMaxLength1024String]
    def maxResults: Option[MaxResults]
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getBucket: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getNextToken: ZIO[Any, AwsError, NonEmptyMaxLength1024String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.ListAccessPointsRequest
  ) extends zio.aws.s3control.model.ListAccessPointsRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val bucket: Option[BucketName] = scala
      .Option(impl.bucket())
      .map(value => zio.aws.s3control.model.primitives.BucketName(value))
    override val nextToken: Option[NonEmptyMaxLength1024String] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.s3control.model.primitives.NonEmptyMaxLength1024String(value)
      )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.s3control.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.ListAccessPointsRequest
  ): zio.aws.s3control.model.ListAccessPointsRequest.ReadOnly = new Wrapper(
    impl
  )
}
