package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.NonEmptyMaxLength1024String
import scala.jdk.CollectionConverters.*
final case class ListAccessPointsForObjectLambdaResponse(
    objectLambdaAccessPointList: Option[
      Iterable[zio.aws.s3control.model.ObjectLambdaAccessPoint]
    ] = None,
    nextToken: Option[NonEmptyMaxLength1024String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.ListAccessPointsForObjectLambdaResponse = {
    import ListAccessPointsForObjectLambdaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.ListAccessPointsForObjectLambdaResponse
      .builder()
      .optionallyWith(
        objectLambdaAccessPointList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.objectLambdaAccessPointList)
      .optionallyWith(
        nextToken.map(value =>
          NonEmptyMaxLength1024String.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.ListAccessPointsForObjectLambdaResponse.ReadOnly =
    zio.aws.s3control.model.ListAccessPointsForObjectLambdaResponse
      .wrap(buildAwsValue())
}
object ListAccessPointsForObjectLambdaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.ListAccessPointsForObjectLambdaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.ListAccessPointsForObjectLambdaResponse =
      zio.aws.s3control.model.ListAccessPointsForObjectLambdaResponse(
        objectLambdaAccessPointList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def objectLambdaAccessPointList
        : Option[List[zio.aws.s3control.model.ObjectLambdaAccessPoint.ReadOnly]]
    def nextToken: Option[NonEmptyMaxLength1024String]
    def getObjectLambdaAccessPointList: ZIO[Any, AwsError, List[
      zio.aws.s3control.model.ObjectLambdaAccessPoint.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "objectLambdaAccessPointList",
      objectLambdaAccessPointList
    )
    def getNextToken: ZIO[Any, AwsError, NonEmptyMaxLength1024String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.ListAccessPointsForObjectLambdaResponse
  ) extends zio.aws.s3control.model.ListAccessPointsForObjectLambdaResponse.ReadOnly {
    override val objectLambdaAccessPointList: Option[
      List[zio.aws.s3control.model.ObjectLambdaAccessPoint.ReadOnly]
    ] = scala
      .Option(impl.objectLambdaAccessPointList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3control.model.ObjectLambdaAccessPoint.wrap(item)
        }.toList
      )
    override val nextToken: Option[NonEmptyMaxLength1024String] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.s3control.model.primitives.NonEmptyMaxLength1024String(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.ListAccessPointsForObjectLambdaResponse
  ): zio.aws.s3control.model.ListAccessPointsForObjectLambdaResponse.ReadOnly =
    new Wrapper(impl)
}
