package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.Prefix
import scala.jdk.CollectionConverters.*
final case class LifecycleRuleFilter(
    prefix: Option[Prefix] = None,
    tag: Option[zio.aws.s3control.model.S3Tag] = None,
    and: Option[zio.aws.s3control.model.LifecycleRuleAndOperator] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.LifecycleRuleFilter = {
    import LifecycleRuleFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.LifecycleRuleFilter
      .builder()
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(tag.map(value => value.buildAwsValue()))(_.tag)
      .optionallyWith(and.map(value => value.buildAwsValue()))(_.and)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.LifecycleRuleFilter.ReadOnly =
    zio.aws.s3control.model.LifecycleRuleFilter.wrap(buildAwsValue())
}
object LifecycleRuleFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.LifecycleRuleFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.LifecycleRuleFilter =
      zio.aws.s3control.model.LifecycleRuleFilter(
        prefix.map(value => value),
        tag.map(value => value.asEditable),
        and.map(value => value.asEditable)
      )
    def prefix: Option[Prefix]
    def tag: Option[zio.aws.s3control.model.S3Tag.ReadOnly]
    def and: Option[zio.aws.s3control.model.LifecycleRuleAndOperator.ReadOnly]
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getTag: ZIO[Any, AwsError, zio.aws.s3control.model.S3Tag.ReadOnly] =
      AwsError.unwrapOptionField("tag", tag)
    def getAnd: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.LifecycleRuleAndOperator.ReadOnly
    ] = AwsError.unwrapOptionField("and", and)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.LifecycleRuleFilter
  ) extends zio.aws.s3control.model.LifecycleRuleFilter.ReadOnly {
    override val prefix: Option[Prefix] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.s3control.model.primitives.Prefix(value))
    override val tag: Option[zio.aws.s3control.model.S3Tag.ReadOnly] = scala
      .Option(impl.tag())
      .map(value => zio.aws.s3control.model.S3Tag.wrap(value))
    override val and
        : Option[zio.aws.s3control.model.LifecycleRuleAndOperator.ReadOnly] =
      scala
        .Option(impl.and())
        .map(value =>
          zio.aws.s3control.model.LifecycleRuleAndOperator.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.LifecycleRuleFilter
  ): zio.aws.s3control.model.LifecycleRuleFilter.ReadOnly = new Wrapper(impl)
}
