package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.ID
import scala.jdk.CollectionConverters.*
final case class LifecycleRule(
    expiration: Option[zio.aws.s3control.model.LifecycleExpiration] = None,
    id: Option[ID] = None,
    filter: Option[zio.aws.s3control.model.LifecycleRuleFilter] = None,
    status: zio.aws.s3control.model.ExpirationStatus,
    transitions: Option[Iterable[zio.aws.s3control.model.Transition]] = None,
    noncurrentVersionTransitions: Option[
      Iterable[zio.aws.s3control.model.NoncurrentVersionTransition]
    ] = None,
    noncurrentVersionExpiration: Option[
      zio.aws.s3control.model.NoncurrentVersionExpiration
    ] = None,
    abortIncompleteMultipartUpload: Option[
      zio.aws.s3control.model.AbortIncompleteMultipartUpload
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.LifecycleRule = {
    import LifecycleRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.LifecycleRule
      .builder()
      .optionallyWith(expiration.map(value => value.buildAwsValue()))(
        _.expiration
      )
      .optionallyWith(id.map(value => ID.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .status(status.unwrap)
      .optionallyWith(
        transitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transitions)
      .optionallyWith(
        noncurrentVersionTransitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.noncurrentVersionTransitions)
      .optionallyWith(
        noncurrentVersionExpiration.map(value => value.buildAwsValue())
      )(_.noncurrentVersionExpiration)
      .optionallyWith(
        abortIncompleteMultipartUpload.map(value => value.buildAwsValue())
      )(_.abortIncompleteMultipartUpload)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.LifecycleRule.ReadOnly =
    zio.aws.s3control.model.LifecycleRule.wrap(buildAwsValue())
}
object LifecycleRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.LifecycleRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.LifecycleRule =
      zio.aws.s3control.model.LifecycleRule(
        expiration.map(value => value.asEditable),
        id.map(value => value),
        filter.map(value => value.asEditable),
        status,
        transitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        noncurrentVersionTransitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        noncurrentVersionExpiration.map(value => value.asEditable),
        abortIncompleteMultipartUpload.map(value => value.asEditable)
      )
    def expiration: Option[zio.aws.s3control.model.LifecycleExpiration.ReadOnly]
    def id: Option[ID]
    def filter: Option[zio.aws.s3control.model.LifecycleRuleFilter.ReadOnly]
    def status: zio.aws.s3control.model.ExpirationStatus
    def transitions: Option[List[zio.aws.s3control.model.Transition.ReadOnly]]
    def noncurrentVersionTransitions: Option[
      List[zio.aws.s3control.model.NoncurrentVersionTransition.ReadOnly]
    ]
    def noncurrentVersionExpiration
        : Option[zio.aws.s3control.model.NoncurrentVersionExpiration.ReadOnly]
    def abortIncompleteMultipartUpload: Option[
      zio.aws.s3control.model.AbortIncompleteMultipartUpload.ReadOnly
    ]
    def getExpiration: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.LifecycleExpiration.ReadOnly
    ] = AwsError.unwrapOptionField("expiration", expiration)
    def getId: ZIO[Any, AwsError, ID] = AwsError.unwrapOptionField("id", id)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.LifecycleRuleFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getStatus: ZIO[Any, Nothing, zio.aws.s3control.model.ExpirationStatus] =
      ZIO.succeed(status)
    def getTransitions: ZIO[Any, AwsError, List[
      zio.aws.s3control.model.Transition.ReadOnly
    ]] = AwsError.unwrapOptionField("transitions", transitions)
    def getNoncurrentVersionTransitions: ZIO[Any, AwsError, List[
      zio.aws.s3control.model.NoncurrentVersionTransition.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "noncurrentVersionTransitions",
      noncurrentVersionTransitions
    )
    def getNoncurrentVersionExpiration: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.NoncurrentVersionExpiration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "noncurrentVersionExpiration",
      noncurrentVersionExpiration
    )
    def getAbortIncompleteMultipartUpload: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.AbortIncompleteMultipartUpload.ReadOnly
    ] = AwsError.unwrapOptionField(
      "abortIncompleteMultipartUpload",
      abortIncompleteMultipartUpload
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.LifecycleRule
  ) extends zio.aws.s3control.model.LifecycleRule.ReadOnly {
    override val expiration
        : Option[zio.aws.s3control.model.LifecycleExpiration.ReadOnly] = scala
      .Option(impl.expiration())
      .map(value => zio.aws.s3control.model.LifecycleExpiration.wrap(value))
    override val id: Option[ID] = scala
      .Option(impl.id())
      .map(value => zio.aws.s3control.model.primitives.ID(value))
    override val filter
        : Option[zio.aws.s3control.model.LifecycleRuleFilter.ReadOnly] = scala
      .Option(impl.filter())
      .map(value => zio.aws.s3control.model.LifecycleRuleFilter.wrap(value))
    override val status: zio.aws.s3control.model.ExpirationStatus =
      zio.aws.s3control.model.ExpirationStatus.wrap(impl.status())
    override val transitions
        : Option[List[zio.aws.s3control.model.Transition.ReadOnly]] = scala
      .Option(impl.transitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3control.model.Transition.wrap(item)
        }.toList
      )
    override val noncurrentVersionTransitions: Option[
      List[zio.aws.s3control.model.NoncurrentVersionTransition.ReadOnly]
    ] = scala
      .Option(impl.noncurrentVersionTransitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3control.model.NoncurrentVersionTransition.wrap(item)
        }.toList
      )
    override val noncurrentVersionExpiration
        : Option[zio.aws.s3control.model.NoncurrentVersionExpiration.ReadOnly] =
      scala
        .Option(impl.noncurrentVersionExpiration())
        .map(value =>
          zio.aws.s3control.model.NoncurrentVersionExpiration.wrap(value)
        )
    override val abortIncompleteMultipartUpload: Option[
      zio.aws.s3control.model.AbortIncompleteMultipartUpload.ReadOnly
    ] = scala
      .Option(impl.abortIncompleteMultipartUpload())
      .map(value =>
        zio.aws.s3control.model.AbortIncompleteMultipartUpload.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.LifecycleRule
  ): zio.aws.s3control.model.LifecycleRule.ReadOnly = new Wrapper(impl)
}
