package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.JobTimeInStateSeconds
import scala.jdk.CollectionConverters.*
final case class JobTimers(
    elapsedTimeInActiveSeconds: Option[JobTimeInStateSeconds] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.JobTimers = {
    import JobTimers.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.JobTimers
      .builder()
      .optionallyWith(
        elapsedTimeInActiveSeconds.map(value =>
          JobTimeInStateSeconds.unwrap(value): java.lang.Long
        )
      )(_.elapsedTimeInActiveSeconds)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.JobTimers.ReadOnly =
    zio.aws.s3control.model.JobTimers.wrap(buildAwsValue())
}
object JobTimers {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.JobTimers
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.JobTimers = zio.aws.s3control.model
      .JobTimers(elapsedTimeInActiveSeconds.map(value => value))
    def elapsedTimeInActiveSeconds: Option[JobTimeInStateSeconds]
    def getElapsedTimeInActiveSeconds
        : ZIO[Any, AwsError, JobTimeInStateSeconds] =
      AwsError.unwrapOptionField(
        "elapsedTimeInActiveSeconds",
        elapsedTimeInActiveSeconds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.JobTimers
  ) extends zio.aws.s3control.model.JobTimers.ReadOnly {
    override val elapsedTimeInActiveSeconds: Option[JobTimeInStateSeconds] =
      scala
        .Option(impl.elapsedTimeInActiveSeconds())
        .map(value =>
          zio.aws.s3control.model.primitives.JobTimeInStateSeconds(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.JobTimers
  ): zio.aws.s3control.model.JobTimers.ReadOnly = new Wrapper(impl)
}
