package zio.aws.s3control.model
import scala.jdk.CollectionConverters.*
sealed trait JobStatus {
  def unwrap: software.amazon.awssdk.services.s3control.model.JobStatus
}
object JobStatus {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.JobStatus
  ): zio.aws.s3control.model.JobStatus = value match {
    case software.amazon.awssdk.services.s3control.model.JobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.JobStatus.ACTIVE =>
      val r = Active
      r
    case software.amazon.awssdk.services.s3control.model.JobStatus.CANCELLED =>
      val r = Cancelled
      r
    case software.amazon.awssdk.services.s3control.model.JobStatus.CANCELLING =>
      val r = Cancelling
      r
    case software.amazon.awssdk.services.s3control.model.JobStatus.COMPLETE =>
      val r = Complete
      r
    case software.amazon.awssdk.services.s3control.model.JobStatus.COMPLETING =>
      val r = Completing
      r
    case software.amazon.awssdk.services.s3control.model.JobStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.s3control.model.JobStatus.FAILING =>
      val r = Failing
      r
    case software.amazon.awssdk.services.s3control.model.JobStatus.NEW =>
      val r = New
      r
    case software.amazon.awssdk.services.s3control.model.JobStatus.PAUSED =>
      val r = Paused
      r
    case software.amazon.awssdk.services.s3control.model.JobStatus.PAUSING =>
      val r = Pausing
      r
    case software.amazon.awssdk.services.s3control.model.JobStatus.PREPARING =>
      val r = Preparing
      r
    case software.amazon.awssdk.services.s3control.model.JobStatus.READY =>
      val r = Ready
      r
    case software.amazon.awssdk.services.s3control.model.JobStatus.SUSPENDED =>
      val r = Suspended
      r
  }
  case object unknownToSdkVersion extends zio.aws.s3control.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.JobStatus =
      software.amazon.awssdk.services.s3control.model.JobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Active extends zio.aws.s3control.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.JobStatus =
      software.amazon.awssdk.services.s3control.model.JobStatus.ACTIVE
  }
  case object Cancelled extends zio.aws.s3control.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.JobStatus =
      software.amazon.awssdk.services.s3control.model.JobStatus.CANCELLED
  }
  case object Cancelling extends zio.aws.s3control.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.JobStatus =
      software.amazon.awssdk.services.s3control.model.JobStatus.CANCELLING
  }
  case object Complete extends zio.aws.s3control.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.JobStatus =
      software.amazon.awssdk.services.s3control.model.JobStatus.COMPLETE
  }
  case object Completing extends zio.aws.s3control.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.JobStatus =
      software.amazon.awssdk.services.s3control.model.JobStatus.COMPLETING
  }
  case object Failed extends zio.aws.s3control.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.JobStatus =
      software.amazon.awssdk.services.s3control.model.JobStatus.FAILED
  }
  case object Failing extends zio.aws.s3control.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.JobStatus =
      software.amazon.awssdk.services.s3control.model.JobStatus.FAILING
  }
  case object New extends zio.aws.s3control.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.JobStatus =
      software.amazon.awssdk.services.s3control.model.JobStatus.NEW
  }
  case object Paused extends zio.aws.s3control.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.JobStatus =
      software.amazon.awssdk.services.s3control.model.JobStatus.PAUSED
  }
  case object Pausing extends zio.aws.s3control.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.JobStatus =
      software.amazon.awssdk.services.s3control.model.JobStatus.PAUSING
  }
  case object Preparing extends zio.aws.s3control.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.JobStatus =
      software.amazon.awssdk.services.s3control.model.JobStatus.PREPARING
  }
  case object Ready extends zio.aws.s3control.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.JobStatus =
      software.amazon.awssdk.services.s3control.model.JobStatus.READY
  }
  case object Suspended extends zio.aws.s3control.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.JobStatus =
      software.amazon.awssdk.services.s3control.model.JobStatus.SUSPENDED
  }
}
