package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class JobManifestGenerator(
    s3JobManifestGenerator: Option[
      zio.aws.s3control.model.S3JobManifestGenerator
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.JobManifestGenerator = {
    import JobManifestGenerator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.JobManifestGenerator
      .builder()
      .optionallyWith(
        s3JobManifestGenerator.map(value => value.buildAwsValue())
      )(_.s3JobManifestGenerator)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.JobManifestGenerator.ReadOnly =
    zio.aws.s3control.model.JobManifestGenerator.wrap(buildAwsValue())
}
object JobManifestGenerator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.JobManifestGenerator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.JobManifestGenerator =
      zio.aws.s3control.model.JobManifestGenerator(
        s3JobManifestGenerator.map(value => value.asEditable)
      )
    def s3JobManifestGenerator
        : Option[zio.aws.s3control.model.S3JobManifestGenerator.ReadOnly]
    def getS3JobManifestGenerator: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3JobManifestGenerator.ReadOnly
    ] = AwsError.unwrapOptionField(
      "s3JobManifestGenerator",
      s3JobManifestGenerator
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.JobManifestGenerator
  ) extends zio.aws.s3control.model.JobManifestGenerator.ReadOnly {
    override val s3JobManifestGenerator
        : Option[zio.aws.s3control.model.S3JobManifestGenerator.ReadOnly] =
      scala
        .Option(impl.s3JobManifestGenerator())
        .map(value =>
          zio.aws.s3control.model.S3JobManifestGenerator.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.JobManifestGenerator
  ): zio.aws.s3control.model.JobManifestGenerator.ReadOnly = new Wrapper(impl)
}
