package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetMultiRegionAccessPointPolicyResponse(
    policy: Option[
      zio.aws.s3control.model.MultiRegionAccessPointPolicyDocument
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyResponse = {
    import GetMultiRegionAccessPointPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyResponse
      .builder()
      .optionallyWith(policy.map(value => value.buildAwsValue()))(_.policy)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.GetMultiRegionAccessPointPolicyResponse.ReadOnly =
    zio.aws.s3control.model.GetMultiRegionAccessPointPolicyResponse
      .wrap(buildAwsValue())
}
object GetMultiRegionAccessPointPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.GetMultiRegionAccessPointPolicyResponse =
      zio.aws.s3control.model.GetMultiRegionAccessPointPolicyResponse(
        policy.map(value => value.asEditable)
      )
    def policy: Option[
      zio.aws.s3control.model.MultiRegionAccessPointPolicyDocument.ReadOnly
    ]
    def getPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.MultiRegionAccessPointPolicyDocument.ReadOnly
    ] = AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyResponse
  ) extends zio.aws.s3control.model.GetMultiRegionAccessPointPolicyResponse.ReadOnly {
    override val policy: Option[
      zio.aws.s3control.model.MultiRegionAccessPointPolicyDocument.ReadOnly
    ] = scala
      .Option(impl.policy())
      .map(value =>
        zio.aws.s3control.model.MultiRegionAccessPointPolicyDocument.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyResponse
  ): zio.aws.s3control.model.GetMultiRegionAccessPointPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
