package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.s3control.model.primitives.{
  CreationDate,
  PublicAccessBlockEnabled,
  BucketName
}
import scala.jdk.CollectionConverters.*
final case class GetBucketResponse(
    bucket: Option[BucketName] = None,
    publicAccessBlockEnabled: Option[PublicAccessBlockEnabled] = None,
    creationDate: Option[CreationDate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetBucketResponse = {
    import GetBucketResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetBucketResponse
      .builder()
      .optionallyWith(
        bucket.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        publicAccessBlockEnabled.map(value =>
          PublicAccessBlockEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.publicAccessBlockEnabled)
      .optionallyWith(
        creationDate.map(value => CreationDate.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.GetBucketResponse.ReadOnly =
    zio.aws.s3control.model.GetBucketResponse.wrap(buildAwsValue())
}
object GetBucketResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetBucketResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.GetBucketResponse =
      zio.aws.s3control.model.GetBucketResponse(
        bucket.map(value => value),
        publicAccessBlockEnabled.map(value => value),
        creationDate.map(value => value)
      )
    def bucket: Option[BucketName]
    def publicAccessBlockEnabled: Option[PublicAccessBlockEnabled]
    def creationDate: Option[CreationDate]
    def getBucket: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getPublicAccessBlockEnabled
        : ZIO[Any, AwsError, PublicAccessBlockEnabled] = AwsError
      .unwrapOptionField("publicAccessBlockEnabled", publicAccessBlockEnabled)
    def getCreationDate: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetBucketResponse
  ) extends zio.aws.s3control.model.GetBucketResponse.ReadOnly {
    override val bucket: Option[BucketName] = scala
      .Option(impl.bucket())
      .map(value => zio.aws.s3control.model.primitives.BucketName(value))
    override val publicAccessBlockEnabled: Option[PublicAccessBlockEnabled] =
      scala
        .Option(impl.publicAccessBlockEnabled())
        .map(value =>
          zio.aws.s3control.model.primitives.PublicAccessBlockEnabled(value)
        )
    override val creationDate: Option[CreationDate] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.s3control.model.primitives.CreationDate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetBucketResponse
  ): zio.aws.s3control.model.GetBucketResponse.ReadOnly = new Wrapper(impl)
}
