package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetAccessPointPolicyStatusForObjectLambdaResponse(
    policyStatus: Option[zio.aws.s3control.model.PolicyStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusForObjectLambdaResponse = {
    import GetAccessPointPolicyStatusForObjectLambdaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusForObjectLambdaResponse
      .builder()
      .optionallyWith(policyStatus.map(value => value.buildAwsValue()))(
        _.policyStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.GetAccessPointPolicyStatusForObjectLambdaResponse.ReadOnly =
    zio.aws.s3control.model.GetAccessPointPolicyStatusForObjectLambdaResponse
      .wrap(buildAwsValue())
}
object GetAccessPointPolicyStatusForObjectLambdaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusForObjectLambdaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.GetAccessPointPolicyStatusForObjectLambdaResponse =
      zio.aws.s3control.model.GetAccessPointPolicyStatusForObjectLambdaResponse(
        policyStatus.map(value => value.asEditable)
      )
    def policyStatus: Option[zio.aws.s3control.model.PolicyStatus.ReadOnly]
    def getPolicyStatus
        : ZIO[Any, AwsError, zio.aws.s3control.model.PolicyStatus.ReadOnly] =
      AwsError.unwrapOptionField("policyStatus", policyStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusForObjectLambdaResponse
  ) extends zio.aws.s3control.model.GetAccessPointPolicyStatusForObjectLambdaResponse.ReadOnly {
    override val policyStatus
        : Option[zio.aws.s3control.model.PolicyStatus.ReadOnly] = scala
      .Option(impl.policyStatus())
      .map(value => zio.aws.s3control.model.PolicyStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusForObjectLambdaResponse
  ): zio.aws.s3control.model.GetAccessPointPolicyStatusForObjectLambdaResponse.ReadOnly =
    new Wrapper(impl)
}
