package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetAccessPointConfigurationForObjectLambdaResponse(
    configuration: Option[zio.aws.s3control.model.ObjectLambdaConfiguration] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetAccessPointConfigurationForObjectLambdaResponse = {
    import GetAccessPointConfigurationForObjectLambdaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetAccessPointConfigurationForObjectLambdaResponse
      .builder()
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.GetAccessPointConfigurationForObjectLambdaResponse.ReadOnly =
    zio.aws.s3control.model.GetAccessPointConfigurationForObjectLambdaResponse
      .wrap(buildAwsValue())
}
object GetAccessPointConfigurationForObjectLambdaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetAccessPointConfigurationForObjectLambdaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.GetAccessPointConfigurationForObjectLambdaResponse =
      zio.aws.s3control.model
        .GetAccessPointConfigurationForObjectLambdaResponse(
          configuration.map(value => value.asEditable)
        )
    def configuration
        : Option[zio.aws.s3control.model.ObjectLambdaConfiguration.ReadOnly]
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.ObjectLambdaConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetAccessPointConfigurationForObjectLambdaResponse
  ) extends zio.aws.s3control.model.GetAccessPointConfigurationForObjectLambdaResponse.ReadOnly {
    override val configuration
        : Option[zio.aws.s3control.model.ObjectLambdaConfiguration.ReadOnly] =
      scala
        .Option(impl.configuration())
        .map(value =>
          zio.aws.s3control.model.ObjectLambdaConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetAccessPointConfigurationForObjectLambdaResponse
  ): zio.aws.s3control.model.GetAccessPointConfigurationForObjectLambdaResponse.ReadOnly =
    new Wrapper(impl)
}
