package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.AsyncRequestTokenARN
import scala.jdk.CollectionConverters.*
final case class DeleteMultiRegionAccessPointResponse(
    requestTokenARN: Option[AsyncRequestTokenARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.DeleteMultiRegionAccessPointResponse = {
    import DeleteMultiRegionAccessPointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.DeleteMultiRegionAccessPointResponse
      .builder()
      .optionallyWith(
        requestTokenARN.map(value =>
          AsyncRequestTokenARN.unwrap(value): java.lang.String
        )
      )(_.requestTokenARN)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.DeleteMultiRegionAccessPointResponse.ReadOnly =
    zio.aws.s3control.model.DeleteMultiRegionAccessPointResponse
      .wrap(buildAwsValue())
}
object DeleteMultiRegionAccessPointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.DeleteMultiRegionAccessPointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.DeleteMultiRegionAccessPointResponse =
      zio.aws.s3control.model.DeleteMultiRegionAccessPointResponse(
        requestTokenARN.map(value => value)
      )
    def requestTokenARN: Option[AsyncRequestTokenARN]
    def getRequestTokenARN: ZIO[Any, AwsError, AsyncRequestTokenARN] =
      AwsError.unwrapOptionField("requestTokenARN", requestTokenARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.DeleteMultiRegionAccessPointResponse
  ) extends zio.aws.s3control.model.DeleteMultiRegionAccessPointResponse.ReadOnly {
    override val requestTokenARN: Option[AsyncRequestTokenARN] = scala
      .Option(impl.requestTokenARN())
      .map(value =>
        zio.aws.s3control.model.primitives.AsyncRequestTokenARN(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.DeleteMultiRegionAccessPointResponse
  ): zio.aws.s3control.model.DeleteMultiRegionAccessPointResponse.ReadOnly =
    new Wrapper(impl)
}
