package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.{S3RegionalBucketArn, Location}
import scala.jdk.CollectionConverters.*
final case class CreateBucketResponse(
    location: Option[Location] = None,
    bucketArn: Option[S3RegionalBucketArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.CreateBucketResponse = {
    import CreateBucketResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.CreateBucketResponse
      .builder()
      .optionallyWith(
        location.map(value => Location.unwrap(value): java.lang.String)
      )(_.location)
      .optionallyWith(
        bucketArn.map(value =>
          S3RegionalBucketArn.unwrap(value): java.lang.String
        )
      )(_.bucketArn)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.CreateBucketResponse.ReadOnly =
    zio.aws.s3control.model.CreateBucketResponse.wrap(buildAwsValue())
}
object CreateBucketResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.CreateBucketResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.CreateBucketResponse =
      zio.aws.s3control.model.CreateBucketResponse(
        location.map(value => value),
        bucketArn.map(value => value)
      )
    def location: Option[Location]
    def bucketArn: Option[S3RegionalBucketArn]
    def getLocation: ZIO[Any, AwsError, Location] =
      AwsError.unwrapOptionField("location", location)
    def getBucketArn: ZIO[Any, AwsError, S3RegionalBucketArn] =
      AwsError.unwrapOptionField("bucketArn", bucketArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.CreateBucketResponse
  ) extends zio.aws.s3control.model.CreateBucketResponse.ReadOnly {
    override val location: Option[Location] = scala
      .Option(impl.location())
      .map(value => zio.aws.s3control.model.primitives.Location(value))
    override val bucketArn: Option[S3RegionalBucketArn] = scala
      .Option(impl.bucketArn())
      .map(value =>
        zio.aws.s3control.model.primitives.S3RegionalBucketArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.CreateBucketResponse
  ): zio.aws.s3control.model.CreateBucketResponse.ReadOnly = new Wrapper(impl)
}
