package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.{
  NonEmptyMaxLength64String,
  GrantRead,
  GrantReadACP,
  ObjectLockEnabledForBucket,
  GrantWriteACP,
  GrantFullControl,
  BucketName,
  GrantWrite
}
import scala.jdk.CollectionConverters.*
final case class CreateBucketRequest(
    acl: Option[zio.aws.s3control.model.BucketCannedACL] = None,
    bucket: BucketName,
    createBucketConfiguration: Option[
      zio.aws.s3control.model.CreateBucketConfiguration
    ] = None,
    grantFullControl: Option[GrantFullControl] = None,
    grantRead: Option[GrantRead] = None,
    grantReadACP: Option[GrantReadACP] = None,
    grantWrite: Option[GrantWrite] = None,
    grantWriteACP: Option[GrantWriteACP] = None,
    objectLockEnabledForBucket: Option[ObjectLockEnabledForBucket] = None,
    outpostId: Option[NonEmptyMaxLength64String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.CreateBucketRequest = {
    import CreateBucketRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.CreateBucketRequest
      .builder()
      .optionallyWith(acl.map(value => value.unwrap))(_.acl)
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        createBucketConfiguration.map(value => value.buildAwsValue())
      )(_.createBucketConfiguration)
      .optionallyWith(
        grantFullControl.map(value =>
          GrantFullControl.unwrap(value): java.lang.String
        )
      )(_.grantFullControl)
      .optionallyWith(
        grantRead.map(value => GrantRead.unwrap(value): java.lang.String)
      )(_.grantRead)
      .optionallyWith(
        grantReadACP.map(value => GrantReadACP.unwrap(value): java.lang.String)
      )(_.grantReadACP)
      .optionallyWith(
        grantWrite.map(value => GrantWrite.unwrap(value): java.lang.String)
      )(_.grantWrite)
      .optionallyWith(
        grantWriteACP.map(value =>
          GrantWriteACP.unwrap(value): java.lang.String
        )
      )(_.grantWriteACP)
      .optionallyWith(
        objectLockEnabledForBucket.map(value =>
          ObjectLockEnabledForBucket.unwrap(value): java.lang.Boolean
        )
      )(_.objectLockEnabledForBucket)
      .optionallyWith(
        outpostId.map(value =>
          NonEmptyMaxLength64String.unwrap(value): java.lang.String
        )
      )(_.outpostId)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.CreateBucketRequest.ReadOnly =
    zio.aws.s3control.model.CreateBucketRequest.wrap(buildAwsValue())
}
object CreateBucketRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.CreateBucketRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.CreateBucketRequest =
      zio.aws.s3control.model.CreateBucketRequest(
        acl.map(value => value),
        bucket,
        createBucketConfiguration.map(value => value.asEditable),
        grantFullControl.map(value => value),
        grantRead.map(value => value),
        grantReadACP.map(value => value),
        grantWrite.map(value => value),
        grantWriteACP.map(value => value),
        objectLockEnabledForBucket.map(value => value),
        outpostId.map(value => value)
      )
    def acl: Option[zio.aws.s3control.model.BucketCannedACL]
    def bucket: BucketName
    def createBucketConfiguration
        : Option[zio.aws.s3control.model.CreateBucketConfiguration.ReadOnly]
    def grantFullControl: Option[GrantFullControl]
    def grantRead: Option[GrantRead]
    def grantReadACP: Option[GrantReadACP]
    def grantWrite: Option[GrantWrite]
    def grantWriteACP: Option[GrantWriteACP]
    def objectLockEnabledForBucket: Option[ObjectLockEnabledForBucket]
    def outpostId: Option[NonEmptyMaxLength64String]
    def getAcl: ZIO[Any, AwsError, zio.aws.s3control.model.BucketCannedACL] =
      AwsError.unwrapOptionField("acl", acl)
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getCreateBucketConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.CreateBucketConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "createBucketConfiguration",
      createBucketConfiguration
    )
    def getGrantFullControl: ZIO[Any, AwsError, GrantFullControl] =
      AwsError.unwrapOptionField("grantFullControl", grantFullControl)
    def getGrantRead: ZIO[Any, AwsError, GrantRead] =
      AwsError.unwrapOptionField("grantRead", grantRead)
    def getGrantReadACP: ZIO[Any, AwsError, GrantReadACP] =
      AwsError.unwrapOptionField("grantReadACP", grantReadACP)
    def getGrantWrite: ZIO[Any, AwsError, GrantWrite] =
      AwsError.unwrapOptionField("grantWrite", grantWrite)
    def getGrantWriteACP: ZIO[Any, AwsError, GrantWriteACP] =
      AwsError.unwrapOptionField("grantWriteACP", grantWriteACP)
    def getObjectLockEnabledForBucket
        : ZIO[Any, AwsError, ObjectLockEnabledForBucket] =
      AwsError.unwrapOptionField(
        "objectLockEnabledForBucket",
        objectLockEnabledForBucket
      )
    def getOutpostId: ZIO[Any, AwsError, NonEmptyMaxLength64String] =
      AwsError.unwrapOptionField("outpostId", outpostId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.CreateBucketRequest
  ) extends zio.aws.s3control.model.CreateBucketRequest.ReadOnly {
    override val acl: Option[zio.aws.s3control.model.BucketCannedACL] = scala
      .Option(impl.acl())
      .map(value => zio.aws.s3control.model.BucketCannedACL.wrap(value))
    override val bucket: BucketName =
      zio.aws.s3control.model.primitives.BucketName(impl.bucket())
    override val createBucketConfiguration
        : Option[zio.aws.s3control.model.CreateBucketConfiguration.ReadOnly] =
      scala
        .Option(impl.createBucketConfiguration())
        .map(value =>
          zio.aws.s3control.model.CreateBucketConfiguration.wrap(value)
        )
    override val grantFullControl: Option[GrantFullControl] = scala
      .Option(impl.grantFullControl())
      .map(value => zio.aws.s3control.model.primitives.GrantFullControl(value))
    override val grantRead: Option[GrantRead] = scala
      .Option(impl.grantRead())
      .map(value => zio.aws.s3control.model.primitives.GrantRead(value))
    override val grantReadACP: Option[GrantReadACP] = scala
      .Option(impl.grantReadACP())
      .map(value => zio.aws.s3control.model.primitives.GrantReadACP(value))
    override val grantWrite: Option[GrantWrite] = scala
      .Option(impl.grantWrite())
      .map(value => zio.aws.s3control.model.primitives.GrantWrite(value))
    override val grantWriteACP: Option[GrantWriteACP] = scala
      .Option(impl.grantWriteACP())
      .map(value => zio.aws.s3control.model.primitives.GrantWriteACP(value))
    override val objectLockEnabledForBucket
        : Option[ObjectLockEnabledForBucket] = scala
      .Option(impl.objectLockEnabledForBucket())
      .map(value =>
        zio.aws.s3control.model.primitives.ObjectLockEnabledForBucket(value)
      )
    override val outpostId: Option[NonEmptyMaxLength64String] = scala
      .Option(impl.outpostId())
      .map(value =>
        zio.aws.s3control.model.primitives.NonEmptyMaxLength64String(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.CreateBucketRequest
  ): zio.aws.s3control.model.CreateBucketRequest.ReadOnly = new Wrapper(impl)
}
