package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.ObjectLambdaAccessPointArn
import scala.jdk.CollectionConverters.*
final case class CreateAccessPointForObjectLambdaResponse(
    objectLambdaAccessPointArn: Option[ObjectLambdaAccessPointArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.CreateAccessPointForObjectLambdaResponse = {
    import CreateAccessPointForObjectLambdaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.CreateAccessPointForObjectLambdaResponse
      .builder()
      .optionallyWith(
        objectLambdaAccessPointArn.map(value =>
          ObjectLambdaAccessPointArn.unwrap(value): java.lang.String
        )
      )(_.objectLambdaAccessPointArn)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.CreateAccessPointForObjectLambdaResponse.ReadOnly =
    zio.aws.s3control.model.CreateAccessPointForObjectLambdaResponse
      .wrap(buildAwsValue())
}
object CreateAccessPointForObjectLambdaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.CreateAccessPointForObjectLambdaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.CreateAccessPointForObjectLambdaResponse =
      zio.aws.s3control.model.CreateAccessPointForObjectLambdaResponse(
        objectLambdaAccessPointArn.map(value => value)
      )
    def objectLambdaAccessPointArn: Option[ObjectLambdaAccessPointArn]
    def getObjectLambdaAccessPointArn
        : ZIO[Any, AwsError, ObjectLambdaAccessPointArn] =
      AwsError.unwrapOptionField(
        "objectLambdaAccessPointArn",
        objectLambdaAccessPointArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.CreateAccessPointForObjectLambdaResponse
  ) extends zio.aws.s3control.model.CreateAccessPointForObjectLambdaResponse.ReadOnly {
    override val objectLambdaAccessPointArn
        : Option[ObjectLambdaAccessPointArn] = scala
      .Option(impl.objectLambdaAccessPointArn())
      .map(value =>
        zio.aws.s3control.model.primitives.ObjectLambdaAccessPointArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.CreateAccessPointForObjectLambdaResponse
  ): zio.aws.s3control.model.CreateAccessPointForObjectLambdaResponse.ReadOnly =
    new Wrapper(impl)
}
