package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BucketLevel(
    activityMetrics: Option[zio.aws.s3control.model.ActivityMetrics] = None,
    prefixLevel: Option[zio.aws.s3control.model.PrefixLevel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.BucketLevel = {
    import BucketLevel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.BucketLevel
      .builder()
      .optionallyWith(activityMetrics.map(value => value.buildAwsValue()))(
        _.activityMetrics
      )
      .optionallyWith(prefixLevel.map(value => value.buildAwsValue()))(
        _.prefixLevel
      )
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.BucketLevel.ReadOnly =
    zio.aws.s3control.model.BucketLevel.wrap(buildAwsValue())
}
object BucketLevel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.BucketLevel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.BucketLevel =
      zio.aws.s3control.model.BucketLevel(
        activityMetrics.map(value => value.asEditable),
        prefixLevel.map(value => value.asEditable)
      )
    def activityMetrics
        : Option[zio.aws.s3control.model.ActivityMetrics.ReadOnly]
    def prefixLevel: Option[zio.aws.s3control.model.PrefixLevel.ReadOnly]
    def getActivityMetrics
        : ZIO[Any, AwsError, zio.aws.s3control.model.ActivityMetrics.ReadOnly] =
      AwsError.unwrapOptionField("activityMetrics", activityMetrics)
    def getPrefixLevel
        : ZIO[Any, AwsError, zio.aws.s3control.model.PrefixLevel.ReadOnly] =
      AwsError.unwrapOptionField("prefixLevel", prefixLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.BucketLevel
  ) extends zio.aws.s3control.model.BucketLevel.ReadOnly {
    override val activityMetrics
        : Option[zio.aws.s3control.model.ActivityMetrics.ReadOnly] = scala
      .Option(impl.activityMetrics())
      .map(value => zio.aws.s3control.model.ActivityMetrics.wrap(value))
    override val prefixLevel
        : Option[zio.aws.s3control.model.PrefixLevel.ReadOnly] = scala
      .Option(impl.prefixLevel())
      .map(value => zio.aws.s3control.model.PrefixLevel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.BucketLevel
  ): zio.aws.s3control.model.BucketLevel.ReadOnly = new Wrapper(impl)
}
