package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.s3control.model.primitives.{
  AsyncRequestStatus,
  AsyncRequestTokenARN,
  AsyncCreationTimestamp
}
import scala.jdk.CollectionConverters.*
final case class AsyncOperation(
    creationTime: Option[AsyncCreationTimestamp] = None,
    operation: Option[zio.aws.s3control.model.AsyncOperationName] = None,
    requestTokenARN: Option[AsyncRequestTokenARN] = None,
    requestParameters: Option[zio.aws.s3control.model.AsyncRequestParameters] =
      None,
    requestStatus: Option[AsyncRequestStatus] = None,
    responseDetails: Option[zio.aws.s3control.model.AsyncResponseDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.AsyncOperation = {
    import AsyncOperation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.AsyncOperation
      .builder()
      .optionallyWith(
        creationTime.map(value => AsyncCreationTimestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(operation.map(value => value.unwrap))(_.operation)
      .optionallyWith(
        requestTokenARN.map(value =>
          AsyncRequestTokenARN.unwrap(value): java.lang.String
        )
      )(_.requestTokenARN)
      .optionallyWith(requestParameters.map(value => value.buildAwsValue()))(
        _.requestParameters
      )
      .optionallyWith(
        requestStatus.map(value =>
          AsyncRequestStatus.unwrap(value): java.lang.String
        )
      )(_.requestStatus)
      .optionallyWith(responseDetails.map(value => value.buildAwsValue()))(
        _.responseDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.AsyncOperation.ReadOnly =
    zio.aws.s3control.model.AsyncOperation.wrap(buildAwsValue())
}
object AsyncOperation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.AsyncOperation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.AsyncOperation =
      zio.aws.s3control.model.AsyncOperation(
        creationTime.map(value => value),
        operation.map(value => value),
        requestTokenARN.map(value => value),
        requestParameters.map(value => value.asEditable),
        requestStatus.map(value => value),
        responseDetails.map(value => value.asEditable)
      )
    def creationTime: Option[AsyncCreationTimestamp]
    def operation: Option[zio.aws.s3control.model.AsyncOperationName]
    def requestTokenARN: Option[AsyncRequestTokenARN]
    def requestParameters
        : Option[zio.aws.s3control.model.AsyncRequestParameters.ReadOnly]
    def requestStatus: Option[AsyncRequestStatus]
    def responseDetails
        : Option[zio.aws.s3control.model.AsyncResponseDetails.ReadOnly]
    def getCreationTime: ZIO[Any, AwsError, AsyncCreationTimestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getOperation
        : ZIO[Any, AwsError, zio.aws.s3control.model.AsyncOperationName] =
      AwsError.unwrapOptionField("operation", operation)
    def getRequestTokenARN: ZIO[Any, AwsError, AsyncRequestTokenARN] =
      AwsError.unwrapOptionField("requestTokenARN", requestTokenARN)
    def getRequestParameters: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.AsyncRequestParameters.ReadOnly
    ] = AwsError.unwrapOptionField("requestParameters", requestParameters)
    def getRequestStatus: ZIO[Any, AwsError, AsyncRequestStatus] =
      AwsError.unwrapOptionField("requestStatus", requestStatus)
    def getResponseDetails: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.AsyncResponseDetails.ReadOnly
    ] = AwsError.unwrapOptionField("responseDetails", responseDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.AsyncOperation
  ) extends zio.aws.s3control.model.AsyncOperation.ReadOnly {
    override val creationTime: Option[AsyncCreationTimestamp] = scala
      .Option(impl.creationTime())
      .map(value =>
        zio.aws.s3control.model.primitives.AsyncCreationTimestamp(value)
      )
    override val operation: Option[zio.aws.s3control.model.AsyncOperationName] =
      scala
        .Option(impl.operation())
        .map(value => zio.aws.s3control.model.AsyncOperationName.wrap(value))
    override val requestTokenARN: Option[AsyncRequestTokenARN] = scala
      .Option(impl.requestTokenARN())
      .map(value =>
        zio.aws.s3control.model.primitives.AsyncRequestTokenARN(value)
      )
    override val requestParameters
        : Option[zio.aws.s3control.model.AsyncRequestParameters.ReadOnly] =
      scala
        .Option(impl.requestParameters())
        .map(value =>
          zio.aws.s3control.model.AsyncRequestParameters.wrap(value)
        )
    override val requestStatus: Option[AsyncRequestStatus] = scala
      .Option(impl.requestStatus())
      .map(value =>
        zio.aws.s3control.model.primitives.AsyncRequestStatus(value)
      )
    override val responseDetails
        : Option[zio.aws.s3control.model.AsyncResponseDetails.ReadOnly] = scala
      .Option(impl.responseDetails())
      .map(value => zio.aws.s3control.model.AsyncResponseDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.AsyncOperation
  ): zio.aws.s3control.model.AsyncOperation.ReadOnly = new Wrapper(impl)
}
