package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.MaxLength1024String
import scala.jdk.CollectionConverters.*
final case class AsyncErrorDetails(
    code: Option[MaxLength1024String] = None,
    message: Option[MaxLength1024String] = None,
    resource: Option[MaxLength1024String] = None,
    requestId: Option[MaxLength1024String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.AsyncErrorDetails = {
    import AsyncErrorDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.AsyncErrorDetails
      .builder()
      .optionallyWith(
        code.map(value => MaxLength1024String.unwrap(value): java.lang.String)
      )(_.code)
      .optionallyWith(
        message.map(value =>
          MaxLength1024String.unwrap(value): java.lang.String
        )
      )(_.message)
      .optionallyWith(
        resource.map(value =>
          MaxLength1024String.unwrap(value): java.lang.String
        )
      )(_.resource)
      .optionallyWith(
        requestId.map(value =>
          MaxLength1024String.unwrap(value): java.lang.String
        )
      )(_.requestId)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.AsyncErrorDetails.ReadOnly =
    zio.aws.s3control.model.AsyncErrorDetails.wrap(buildAwsValue())
}
object AsyncErrorDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.AsyncErrorDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.AsyncErrorDetails =
      zio.aws.s3control.model.AsyncErrorDetails(
        code.map(value => value),
        message.map(value => value),
        resource.map(value => value),
        requestId.map(value => value)
      )
    def code: Option[MaxLength1024String]
    def message: Option[MaxLength1024String]
    def resource: Option[MaxLength1024String]
    def requestId: Option[MaxLength1024String]
    def getCode: ZIO[Any, AwsError, MaxLength1024String] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, MaxLength1024String] =
      AwsError.unwrapOptionField("message", message)
    def getResource: ZIO[Any, AwsError, MaxLength1024String] =
      AwsError.unwrapOptionField("resource", resource)
    def getRequestId: ZIO[Any, AwsError, MaxLength1024String] =
      AwsError.unwrapOptionField("requestId", requestId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.AsyncErrorDetails
  ) extends zio.aws.s3control.model.AsyncErrorDetails.ReadOnly {
    override val code: Option[MaxLength1024String] = scala
      .Option(impl.code())
      .map(value =>
        zio.aws.s3control.model.primitives.MaxLength1024String(value)
      )
    override val message: Option[MaxLength1024String] = scala
      .Option(impl.message())
      .map(value =>
        zio.aws.s3control.model.primitives.MaxLength1024String(value)
      )
    override val resource: Option[MaxLength1024String] = scala
      .Option(impl.resource())
      .map(value =>
        zio.aws.s3control.model.primitives.MaxLength1024String(value)
      )
    override val requestId: Option[MaxLength1024String] = scala
      .Option(impl.requestId())
      .map(value =>
        zio.aws.s3control.model.primitives.MaxLength1024String(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.AsyncErrorDetails
  ): zio.aws.s3control.model.AsyncErrorDetails.ReadOnly = new Wrapper(impl)
}
