package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.IsEnabled
import scala.jdk.CollectionConverters.*
final case class ActivityMetrics(isEnabled: Option[IsEnabled] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.ActivityMetrics = {
    import ActivityMetrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.ActivityMetrics
      .builder()
      .optionallyWith(
        isEnabled.map(value => IsEnabled.unwrap(value): java.lang.Boolean)
      )(_.isEnabled)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.ActivityMetrics.ReadOnly =
    zio.aws.s3control.model.ActivityMetrics.wrap(buildAwsValue())
}
object ActivityMetrics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.ActivityMetrics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.ActivityMetrics =
      zio.aws.s3control.model.ActivityMetrics(isEnabled.map(value => value))
    def isEnabled: Option[IsEnabled]
    def getIsEnabled: ZIO[Any, AwsError, IsEnabled] =
      AwsError.unwrapOptionField("isEnabled", isEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.ActivityMetrics
  ) extends zio.aws.s3control.model.ActivityMetrics.ReadOnly {
    override val isEnabled: Option[IsEnabled] = scala
      .Option(impl.isEnabled())
      .map(value => zio.aws.s3control.model.primitives.IsEnabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.ActivityMetrics
  ): zio.aws.s3control.model.ActivityMetrics.ReadOnly = new Wrapper(impl)
}
