package zio.aws.s3control.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.DaysAfterInitiation
import scala.jdk.CollectionConverters.*
final case class AbortIncompleteMultipartUpload(
    daysAfterInitiation: Option[DaysAfterInitiation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.AbortIncompleteMultipartUpload = {
    import AbortIncompleteMultipartUpload.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.AbortIncompleteMultipartUpload
      .builder()
      .optionallyWith(
        daysAfterInitiation.map(value =>
          DaysAfterInitiation.unwrap(value): Integer
        )
      )(_.daysAfterInitiation)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.AbortIncompleteMultipartUpload.ReadOnly =
    zio.aws.s3control.model.AbortIncompleteMultipartUpload.wrap(buildAwsValue())
}
object AbortIncompleteMultipartUpload {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.AbortIncompleteMultipartUpload
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.AbortIncompleteMultipartUpload =
      zio.aws.s3control.model
        .AbortIncompleteMultipartUpload(daysAfterInitiation.map(value => value))
    def daysAfterInitiation: Option[DaysAfterInitiation]
    def getDaysAfterInitiation: ZIO[Any, AwsError, DaysAfterInitiation] =
      AwsError.unwrapOptionField("daysAfterInitiation", daysAfterInitiation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.AbortIncompleteMultipartUpload
  ) extends zio.aws.s3control.model.AbortIncompleteMultipartUpload.ReadOnly {
    override val daysAfterInitiation: Option[DaysAfterInitiation] = scala
      .Option(impl.daysAfterInitiation())
      .map(value =>
        zio.aws.s3control.model.primitives.DaysAfterInitiation(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.AbortIncompleteMultipartUpload
  ): zio.aws.s3control.model.AbortIncompleteMultipartUpload.ReadOnly =
    new Wrapper(impl)
}
