package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3GeneratedManifestDescriptor(
    format: Optional[zio.aws.s3control.model.GeneratedManifestFormat] =
      Optional.Absent,
    location: Optional[zio.aws.s3control.model.JobManifestLocation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.S3GeneratedManifestDescriptor = {
    import S3GeneratedManifestDescriptor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.S3GeneratedManifestDescriptor
      .builder()
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.S3GeneratedManifestDescriptor.ReadOnly =
    zio.aws.s3control.model.S3GeneratedManifestDescriptor.wrap(buildAwsValue())
}
object S3GeneratedManifestDescriptor {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.S3GeneratedManifestDescriptor
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.S3GeneratedManifestDescriptor =
      zio.aws.s3control.model.S3GeneratedManifestDescriptor(
        format.map(value => value),
        location.map(value => value.asEditable)
      )
    def format: Optional[zio.aws.s3control.model.GeneratedManifestFormat]
    def location: Optional[zio.aws.s3control.model.JobManifestLocation.ReadOnly]
    def getFormat
        : ZIO[Any, AwsError, zio.aws.s3control.model.GeneratedManifestFormat] =
      AwsError.unwrapOptionField("format", format)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.JobManifestLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.S3GeneratedManifestDescriptor
  ) extends zio.aws.s3control.model.S3GeneratedManifestDescriptor.ReadOnly {
    override val format
        : Optional[zio.aws.s3control.model.GeneratedManifestFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.format())
        .map(value =>
          zio.aws.s3control.model.GeneratedManifestFormat.wrap(value)
        )
    override val location
        : Optional[zio.aws.s3control.model.JobManifestLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.s3control.model.JobManifestLocation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.S3GeneratedManifestDescriptor
  ): zio.aws.s3control.model.S3GeneratedManifestDescriptor.ReadOnly =
    new Wrapper(impl)
}
