package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{AccessPointName, AccountId}
import scala.jdk.CollectionConverters._
final case class GetAccessPointPolicyStatusRequest(
    accountId: AccountId,
    name: AccessPointName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusRequest = {
    import GetAccessPointPolicyStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .name(AccessPointName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.GetAccessPointPolicyStatusRequest.ReadOnly =
    zio.aws.s3control.model.GetAccessPointPolicyStatusRequest
      .wrap(buildAwsValue())
}
object GetAccessPointPolicyStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.GetAccessPointPolicyStatusRequest =
      zio.aws.s3control.model.GetAccessPointPolicyStatusRequest(accountId, name)
    def accountId: AccountId
    def name: AccessPointName
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getName: ZIO[Any, Nothing, AccessPointName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusRequest
  ) extends zio.aws.s3control.model.GetAccessPointPolicyStatusRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val name: AccessPointName =
      zio.aws.s3control.model.primitives.AccessPointName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusRequest
  ): zio.aws.s3control.model.GetAccessPointPolicyStatusRequest.ReadOnly =
    new Wrapper(impl)
}
