package zio.aws.s3control.model
import scala.jdk.CollectionConverters._
sealed trait ObjectLambdaAccessPointAliasStatus {
  def unwrap: software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPointAliasStatus
}
object ObjectLambdaAccessPointAliasStatus {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPointAliasStatus
  ): zio.aws.s3control.model.ObjectLambdaAccessPointAliasStatus = value match {
    case software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPointAliasStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPointAliasStatus.PROVISIONING =>
      val r = PROVISIONING
      r
    case software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPointAliasStatus.READY =>
      val r = READY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.ObjectLambdaAccessPointAliasStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPointAliasStatus =
      software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPointAliasStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PROVISIONING
      extends zio.aws.s3control.model.ObjectLambdaAccessPointAliasStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPointAliasStatus =
      software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPointAliasStatus.PROVISIONING
  }
  case object READY
      extends zio.aws.s3control.model.ObjectLambdaAccessPointAliasStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPointAliasStatus =
      software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPointAliasStatus.READY
  }
}
