package zio.aws.s3control.model
import scala.jdk.CollectionConverters._
sealed trait ReplicationTimeStatus {
  def unwrap
      : software.amazon.awssdk.services.s3control.model.ReplicationTimeStatus
}
object ReplicationTimeStatus {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.ReplicationTimeStatus
  ): zio.aws.s3control.model.ReplicationTimeStatus = value match {
    case software.amazon.awssdk.services.s3control.model.ReplicationTimeStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.ReplicationTimeStatus.ENABLED =>
      val r = Enabled
      r
    case software.amazon.awssdk.services.s3control.model.ReplicationTimeStatus.DISABLED =>
      val r = Disabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.ReplicationTimeStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ReplicationTimeStatus =
      software.amazon.awssdk.services.s3control.model.ReplicationTimeStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled extends zio.aws.s3control.model.ReplicationTimeStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ReplicationTimeStatus =
      software.amazon.awssdk.services.s3control.model.ReplicationTimeStatus.ENABLED
  }
  case object Disabled extends zio.aws.s3control.model.ReplicationTimeStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ReplicationTimeStatus =
      software.amazon.awssdk.services.s3control.model.ReplicationTimeStatus.DISABLED
  }
}
