package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.{AccountId, RegionName, BucketName}
import scala.jdk.CollectionConverters._
final case class RegionReport(
    bucket: Optional[BucketName] = Optional.Absent,
    region: Optional[RegionName] = Optional.Absent,
    bucketAccountId: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.RegionReport = {
    import RegionReport.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.RegionReport
      .builder()
      .optionallyWith(
        bucket.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        region.map(value => RegionName.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        bucketAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.bucketAccountId)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.RegionReport.ReadOnly =
    zio.aws.s3control.model.RegionReport.wrap(buildAwsValue())
}
object RegionReport {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.RegionReport
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.RegionReport =
      zio.aws.s3control.model.RegionReport(
        bucket.map(value => value),
        region.map(value => value),
        bucketAccountId.map(value => value)
      )
    def bucket: Optional[BucketName]
    def region: Optional[RegionName]
    def bucketAccountId: Optional[AccountId]
    def getBucket: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getRegion: ZIO[Any, AwsError, RegionName] =
      AwsError.unwrapOptionField("region", region)
    def getBucketAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("bucketAccountId", bucketAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.RegionReport
  ) extends zio.aws.s3control.model.RegionReport.ReadOnly {
    override val bucket: Optional[BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => zio.aws.s3control.model.primitives.BucketName(value))
    override val region: Optional[RegionName] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.s3control.model.primitives.RegionName(value))
    override val bucketAccountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketAccountId())
      .map(value => zio.aws.s3control.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.RegionReport
  ): zio.aws.s3control.model.RegionReport.ReadOnly = new Wrapper(impl)
}
