package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SseKmsEncryptedObjects(
    status: zio.aws.s3control.model.SseKmsEncryptedObjectsStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.SseKmsEncryptedObjects = {
    import SseKmsEncryptedObjects.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.SseKmsEncryptedObjects
      .builder()
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.SseKmsEncryptedObjects.ReadOnly =
    zio.aws.s3control.model.SseKmsEncryptedObjects.wrap(buildAwsValue())
}
object SseKmsEncryptedObjects {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.SseKmsEncryptedObjects
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.SseKmsEncryptedObjects =
      zio.aws.s3control.model.SseKmsEncryptedObjects(status)
    def status: zio.aws.s3control.model.SseKmsEncryptedObjectsStatus
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.s3control.model.SseKmsEncryptedObjectsStatus
    ] = ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.SseKmsEncryptedObjects
  ) extends zio.aws.s3control.model.SseKmsEncryptedObjects.ReadOnly {
    override val status: zio.aws.s3control.model.SseKmsEncryptedObjectsStatus =
      zio.aws.s3control.model.SseKmsEncryptedObjectsStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.SseKmsEncryptedObjects
  ): zio.aws.s3control.model.SseKmsEncryptedObjects.ReadOnly = new Wrapper(impl)
}
