package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.MultiRegionAccessPointName
import scala.jdk.CollectionConverters._
final case class CreateMultiRegionAccessPointInput(
    name: MultiRegionAccessPointName,
    publicAccessBlock: Optional[
      zio.aws.s3control.model.PublicAccessBlockConfiguration
    ] = Optional.Absent,
    regions: Iterable[zio.aws.s3control.model.Region]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.CreateMultiRegionAccessPointInput = {
    import CreateMultiRegionAccessPointInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.CreateMultiRegionAccessPointInput
      .builder()
      .name(MultiRegionAccessPointName.unwrap(name): java.lang.String)
      .optionallyWith(publicAccessBlock.map(value => value.buildAwsValue()))(
        _.publicAccessBlock
      )
      .regions(regions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.CreateMultiRegionAccessPointInput.ReadOnly =
    zio.aws.s3control.model.CreateMultiRegionAccessPointInput
      .wrap(buildAwsValue())
}
object CreateMultiRegionAccessPointInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.CreateMultiRegionAccessPointInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.CreateMultiRegionAccessPointInput =
      zio.aws.s3control.model.CreateMultiRegionAccessPointInput(
        name,
        publicAccessBlock.map(value => value.asEditable),
        regions.map { item =>
          item.asEditable
        }
      )
    def name: MultiRegionAccessPointName
    def publicAccessBlock: Optional[
      zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly
    ]
    def regions: List[zio.aws.s3control.model.Region.ReadOnly]
    def getName: ZIO[Any, Nothing, MultiRegionAccessPointName] =
      ZIO.succeed(name)
    def getPublicAccessBlock: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("publicAccessBlock", publicAccessBlock)
    def getRegions
        : ZIO[Any, Nothing, List[zio.aws.s3control.model.Region.ReadOnly]] =
      ZIO.succeed(regions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.CreateMultiRegionAccessPointInput
  ) extends zio.aws.s3control.model.CreateMultiRegionAccessPointInput.ReadOnly {
    override val name: MultiRegionAccessPointName =
      zio.aws.s3control.model.primitives.MultiRegionAccessPointName(impl.name())
    override val publicAccessBlock: Optional[
      zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.publicAccessBlock())
      .map(value =>
        zio.aws.s3control.model.PublicAccessBlockConfiguration.wrap(value)
      )
    override val regions: List[zio.aws.s3control.model.Region.ReadOnly] = impl
      .regions()
      .asScala
      .map { item =>
        zio.aws.s3control.model.Region.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.CreateMultiRegionAccessPointInput
  ): zio.aws.s3control.model.CreateMultiRegionAccessPointInput.ReadOnly =
    new Wrapper(impl)
}
