package zio.aws.s3control.model
import scala.jdk.CollectionConverters._
sealed trait ReplicaModificationsStatus {
  def unwrap: software.amazon.awssdk.services.s3control.model.ReplicaModificationsStatus
}
object ReplicaModificationsStatus {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.ReplicaModificationsStatus
  ): zio.aws.s3control.model.ReplicaModificationsStatus = value match {
    case software.amazon.awssdk.services.s3control.model.ReplicaModificationsStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.ReplicaModificationsStatus.ENABLED =>
      val r = Enabled
      r
    case software.amazon.awssdk.services.s3control.model.ReplicaModificationsStatus.DISABLED =>
      val r = Disabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.ReplicaModificationsStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ReplicaModificationsStatus =
      software.amazon.awssdk.services.s3control.model.ReplicaModificationsStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled
      extends zio.aws.s3control.model.ReplicaModificationsStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ReplicaModificationsStatus =
      software.amazon.awssdk.services.s3control.model.ReplicaModificationsStatus.ENABLED
  }
  case object Disabled
      extends zio.aws.s3control.model.ReplicaModificationsStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ReplicaModificationsStatus =
      software.amazon.awssdk.services.s3control.model.ReplicaModificationsStatus.DISABLED
  }
}
