package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{Policy, MultiRegionAccessPointName}
import scala.jdk.CollectionConverters._
final case class PutMultiRegionAccessPointPolicyInput(
    name: MultiRegionAccessPointName,
    policy: Policy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.PutMultiRegionAccessPointPolicyInput = {
    import PutMultiRegionAccessPointPolicyInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.PutMultiRegionAccessPointPolicyInput
      .builder()
      .name(MultiRegionAccessPointName.unwrap(name): java.lang.String)
      .policy(Policy.unwrap(policy): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.PutMultiRegionAccessPointPolicyInput.ReadOnly =
    zio.aws.s3control.model.PutMultiRegionAccessPointPolicyInput
      .wrap(buildAwsValue())
}
object PutMultiRegionAccessPointPolicyInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.PutMultiRegionAccessPointPolicyInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.PutMultiRegionAccessPointPolicyInput =
      zio.aws.s3control.model.PutMultiRegionAccessPointPolicyInput(name, policy)
    def name: MultiRegionAccessPointName
    def policy: Policy
    def getName: ZIO[Any, Nothing, MultiRegionAccessPointName] =
      ZIO.succeed(name)
    def getPolicy: ZIO[Any, Nothing, Policy] = ZIO.succeed(policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.PutMultiRegionAccessPointPolicyInput
  ) extends zio.aws.s3control.model.PutMultiRegionAccessPointPolicyInput.ReadOnly {
    override val name: MultiRegionAccessPointName =
      zio.aws.s3control.model.primitives.MultiRegionAccessPointName(impl.name())
    override val policy: Policy =
      zio.aws.s3control.model.primitives.Policy(impl.policy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.PutMultiRegionAccessPointPolicyInput
  ): zio.aws.s3control.model.PutMultiRegionAccessPointPolicyInput.ReadOnly =
    new Wrapper(impl)
}
