package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.MultiRegionAccessPointId
import scala.jdk.CollectionConverters._
final case class GetMultiRegionAccessPointRoutesResponse(
    mrap: Optional[MultiRegionAccessPointId] = Optional.Absent,
    routes: Optional[
      Iterable[zio.aws.s3control.model.MultiRegionAccessPointRoute]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointRoutesResponse = {
    import GetMultiRegionAccessPointRoutesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointRoutesResponse
      .builder()
      .optionallyWith(
        mrap.map(value =>
          MultiRegionAccessPointId.unwrap(value): java.lang.String
        )
      )(_.mrap)
      .optionallyWith(
        routes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routes)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.GetMultiRegionAccessPointRoutesResponse.ReadOnly =
    zio.aws.s3control.model.GetMultiRegionAccessPointRoutesResponse
      .wrap(buildAwsValue())
}
object GetMultiRegionAccessPointRoutesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointRoutesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.GetMultiRegionAccessPointRoutesResponse =
      zio.aws.s3control.model.GetMultiRegionAccessPointRoutesResponse(
        mrap.map(value => value),
        routes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def mrap: Optional[MultiRegionAccessPointId]
    def routes: Optional[
      List[zio.aws.s3control.model.MultiRegionAccessPointRoute.ReadOnly]
    ]
    def getMrap: ZIO[Any, AwsError, MultiRegionAccessPointId] =
      AwsError.unwrapOptionField("mrap", mrap)
    def getRoutes: ZIO[Any, AwsError, List[
      zio.aws.s3control.model.MultiRegionAccessPointRoute.ReadOnly
    ]] = AwsError.unwrapOptionField("routes", routes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointRoutesResponse
  ) extends zio.aws.s3control.model.GetMultiRegionAccessPointRoutesResponse.ReadOnly {
    override val mrap: Optional[MultiRegionAccessPointId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mrap())
        .map(value =>
          zio.aws.s3control.model.primitives.MultiRegionAccessPointId(value)
        )
    override val routes: Optional[
      List[zio.aws.s3control.model.MultiRegionAccessPointRoute.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.routes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3control.model.MultiRegionAccessPointRoute.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointRoutesResponse
  ): zio.aws.s3control.model.GetMultiRegionAccessPointRoutesResponse.ReadOnly =
    new Wrapper(impl)
}
