package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.{BucketIdentifierString, AccountId}
import scala.jdk.CollectionConverters._
final case class Destination(
    account: Optional[AccountId] = Optional.Absent,
    bucket: BucketIdentifierString,
    replicationTime: Optional[zio.aws.s3control.model.ReplicationTime] =
      Optional.Absent,
    accessControlTranslation: Optional[
      zio.aws.s3control.model.AccessControlTranslation
    ] = Optional.Absent,
    encryptionConfiguration: Optional[
      zio.aws.s3control.model.EncryptionConfiguration
    ] = Optional.Absent,
    metrics: Optional[zio.aws.s3control.model.Metrics] = Optional.Absent,
    storageClass: Optional[zio.aws.s3control.model.ReplicationStorageClass] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.Destination = {
    import Destination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.Destination
      .builder()
      .optionallyWith(
        account.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.account)
      .bucket(BucketIdentifierString.unwrap(bucket): java.lang.String)
      .optionallyWith(replicationTime.map(value => value.buildAwsValue()))(
        _.replicationTime
      )
      .optionallyWith(
        accessControlTranslation.map(value => value.buildAwsValue())
      )(_.accessControlTranslation)
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .optionallyWith(metrics.map(value => value.buildAwsValue()))(_.metrics)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.Destination.ReadOnly =
    zio.aws.s3control.model.Destination.wrap(buildAwsValue())
}
object Destination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.Destination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.Destination =
      zio.aws.s3control.model.Destination(
        account.map(value => value),
        bucket,
        replicationTime.map(value => value.asEditable),
        accessControlTranslation.map(value => value.asEditable),
        encryptionConfiguration.map(value => value.asEditable),
        metrics.map(value => value.asEditable),
        storageClass.map(value => value)
      )
    def account: Optional[AccountId]
    def bucket: BucketIdentifierString
    def replicationTime
        : Optional[zio.aws.s3control.model.ReplicationTime.ReadOnly]
    def accessControlTranslation
        : Optional[zio.aws.s3control.model.AccessControlTranslation.ReadOnly]
    def encryptionConfiguration
        : Optional[zio.aws.s3control.model.EncryptionConfiguration.ReadOnly]
    def metrics: Optional[zio.aws.s3control.model.Metrics.ReadOnly]
    def storageClass: Optional[zio.aws.s3control.model.ReplicationStorageClass]
    def getAccount: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("account", account)
    def getBucket: ZIO[Any, Nothing, BucketIdentifierString] =
      ZIO.succeed(bucket)
    def getReplicationTime
        : ZIO[Any, AwsError, zio.aws.s3control.model.ReplicationTime.ReadOnly] =
      AwsError.unwrapOptionField("replicationTime", replicationTime)
    def getAccessControlTranslation: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.AccessControlTranslation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "accessControlTranslation",
      accessControlTranslation
    )
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.EncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
    def getMetrics
        : ZIO[Any, AwsError, zio.aws.s3control.model.Metrics.ReadOnly] =
      AwsError.unwrapOptionField("metrics", metrics)
    def getStorageClass
        : ZIO[Any, AwsError, zio.aws.s3control.model.ReplicationStorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.Destination
  ) extends zio.aws.s3control.model.Destination.ReadOnly {
    override val account: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.account())
      .map(value => zio.aws.s3control.model.primitives.AccountId(value))
    override val bucket: BucketIdentifierString =
      zio.aws.s3control.model.primitives.BucketIdentifierString(impl.bucket())
    override val replicationTime
        : Optional[zio.aws.s3control.model.ReplicationTime.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationTime())
        .map(value => zio.aws.s3control.model.ReplicationTime.wrap(value))
    override val accessControlTranslation
        : Optional[zio.aws.s3control.model.AccessControlTranslation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessControlTranslation())
        .map(value =>
          zio.aws.s3control.model.AccessControlTranslation.wrap(value)
        )
    override val encryptionConfiguration
        : Optional[zio.aws.s3control.model.EncryptionConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionConfiguration())
        .map(value =>
          zio.aws.s3control.model.EncryptionConfiguration.wrap(value)
        )
    override val metrics: Optional[zio.aws.s3control.model.Metrics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metrics())
        .map(value => zio.aws.s3control.model.Metrics.wrap(value))
    override val storageClass
        : Optional[zio.aws.s3control.model.ReplicationStorageClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageClass())
        .map(value =>
          zio.aws.s3control.model.ReplicationStorageClass.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.Destination
  ): zio.aws.s3control.model.Destination.ReadOnly = new Wrapper(impl)
}
