package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.{
  AwsLambdaTransformationPayload,
  FunctionArnString
}
import scala.jdk.CollectionConverters._
final case class AwsLambdaTransformation(
    functionArn: FunctionArnString,
    functionPayload: Optional[AwsLambdaTransformationPayload] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.AwsLambdaTransformation = {
    import AwsLambdaTransformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.AwsLambdaTransformation
      .builder()
      .functionArn(FunctionArnString.unwrap(functionArn): java.lang.String)
      .optionallyWith(
        functionPayload.map(value =>
          AwsLambdaTransformationPayload.unwrap(value): java.lang.String
        )
      )(_.functionPayload)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.AwsLambdaTransformation.ReadOnly =
    zio.aws.s3control.model.AwsLambdaTransformation.wrap(buildAwsValue())
}
object AwsLambdaTransformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.AwsLambdaTransformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.AwsLambdaTransformation =
      zio.aws.s3control.model.AwsLambdaTransformation(
        functionArn,
        functionPayload.map(value => value)
      )
    def functionArn: FunctionArnString
    def functionPayload: Optional[AwsLambdaTransformationPayload]
    def getFunctionArn: ZIO[Any, Nothing, FunctionArnString] =
      ZIO.succeed(functionArn)
    def getFunctionPayload: ZIO[Any, AwsError, AwsLambdaTransformationPayload] =
      AwsError.unwrapOptionField("functionPayload", functionPayload)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.AwsLambdaTransformation
  ) extends zio.aws.s3control.model.AwsLambdaTransformation.ReadOnly {
    override val functionArn: FunctionArnString =
      zio.aws.s3control.model.primitives.FunctionArnString(impl.functionArn())
    override val functionPayload: Optional[AwsLambdaTransformationPayload] =
      zio.aws.core.internal
        .optionalFromNullable(impl.functionPayload())
        .map(value =>
          zio.aws.s3control.model.primitives
            .AwsLambdaTransformationPayload(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.AwsLambdaTransformation
  ): zio.aws.s3control.model.AwsLambdaTransformation.ReadOnly = new Wrapper(
    impl
  )
}
