package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{
  MultiRegionAccessPointName,
  AccountId
}
import scala.jdk.CollectionConverters._
final case class GetMultiRegionAccessPointRequest(
    accountId: AccountId,
    name: MultiRegionAccessPointName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointRequest = {
    import GetMultiRegionAccessPointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .name(MultiRegionAccessPointName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.GetMultiRegionAccessPointRequest.ReadOnly =
    zio.aws.s3control.model.GetMultiRegionAccessPointRequest
      .wrap(buildAwsValue())
}
object GetMultiRegionAccessPointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.GetMultiRegionAccessPointRequest =
      zio.aws.s3control.model.GetMultiRegionAccessPointRequest(accountId, name)
    def accountId: AccountId
    def name: MultiRegionAccessPointName
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getName: ZIO[Any, Nothing, MultiRegionAccessPointName] =
      ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointRequest
  ) extends zio.aws.s3control.model.GetMultiRegionAccessPointRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val name: MultiRegionAccessPointName =
      zio.aws.s3control.model.primitives.MultiRegionAccessPointName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointRequest
  ): zio.aws.s3control.model.GetMultiRegionAccessPointRequest.ReadOnly =
    new Wrapper(impl)
}
