package zio.aws.s3control.model
import scala.jdk.CollectionConverters._
sealed trait ReplicationStorageClass {
  def unwrap
      : software.amazon.awssdk.services.s3control.model.ReplicationStorageClass
}
object ReplicationStorageClass {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.ReplicationStorageClass
  ): zio.aws.s3control.model.ReplicationStorageClass = value match {
    case software.amazon.awssdk.services.s3control.model.ReplicationStorageClass.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.ReplicationStorageClass.STANDARD =>
      val r = STANDARD
      r
    case software.amazon.awssdk.services.s3control.model.ReplicationStorageClass.REDUCED_REDUNDANCY =>
      val r = REDUCED_REDUNDANCY
      r
    case software.amazon.awssdk.services.s3control.model.ReplicationStorageClass.STANDARD_IA =>
      val r = STANDARD_IA
      r
    case software.amazon.awssdk.services.s3control.model.ReplicationStorageClass.ONEZONE_IA =>
      val r = ONEZONE_IA
      r
    case software.amazon.awssdk.services.s3control.model.ReplicationStorageClass.INTELLIGENT_TIERING =>
      val r = INTELLIGENT_TIERING
      r
    case software.amazon.awssdk.services.s3control.model.ReplicationStorageClass.GLACIER =>
      val r = GLACIER
      r
    case software.amazon.awssdk.services.s3control.model.ReplicationStorageClass.DEEP_ARCHIVE =>
      val r = DEEP_ARCHIVE
      r
    case software.amazon.awssdk.services.s3control.model.ReplicationStorageClass.OUTPOSTS =>
      val r = OUTPOSTS
      r
    case software.amazon.awssdk.services.s3control.model.ReplicationStorageClass.GLACIER_IR =>
      val r = GLACIER_IR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.ReplicationStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ReplicationStorageClass =
      software.amazon.awssdk.services.s3control.model.ReplicationStorageClass.UNKNOWN_TO_SDK_VERSION
  }
  case object STANDARD extends zio.aws.s3control.model.ReplicationStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ReplicationStorageClass =
      software.amazon.awssdk.services.s3control.model.ReplicationStorageClass.STANDARD
  }
  case object REDUCED_REDUNDANCY
      extends zio.aws.s3control.model.ReplicationStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ReplicationStorageClass =
      software.amazon.awssdk.services.s3control.model.ReplicationStorageClass.REDUCED_REDUNDANCY
  }
  case object STANDARD_IA
      extends zio.aws.s3control.model.ReplicationStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ReplicationStorageClass =
      software.amazon.awssdk.services.s3control.model.ReplicationStorageClass.STANDARD_IA
  }
  case object ONEZONE_IA
      extends zio.aws.s3control.model.ReplicationStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ReplicationStorageClass =
      software.amazon.awssdk.services.s3control.model.ReplicationStorageClass.ONEZONE_IA
  }
  case object INTELLIGENT_TIERING
      extends zio.aws.s3control.model.ReplicationStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ReplicationStorageClass =
      software.amazon.awssdk.services.s3control.model.ReplicationStorageClass.INTELLIGENT_TIERING
  }
  case object GLACIER extends zio.aws.s3control.model.ReplicationStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ReplicationStorageClass =
      software.amazon.awssdk.services.s3control.model.ReplicationStorageClass.GLACIER
  }
  case object DEEP_ARCHIVE
      extends zio.aws.s3control.model.ReplicationStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ReplicationStorageClass =
      software.amazon.awssdk.services.s3control.model.ReplicationStorageClass.DEEP_ARCHIVE
  }
  case object OUTPOSTS extends zio.aws.s3control.model.ReplicationStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ReplicationStorageClass =
      software.amazon.awssdk.services.s3control.model.ReplicationStorageClass.OUTPOSTS
  }
  case object GLACIER_IR
      extends zio.aws.s3control.model.ReplicationStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ReplicationStorageClass =
      software.amazon.awssdk.services.s3control.model.ReplicationStorageClass.GLACIER_IR
  }
}
