package zio.aws.s3control.model
import scala.jdk.CollectionConverters._
sealed trait OwnerOverride {
  def unwrap: software.amazon.awssdk.services.s3control.model.OwnerOverride
}
object OwnerOverride {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.OwnerOverride
  ): zio.aws.s3control.model.OwnerOverride = value match {
    case software.amazon.awssdk.services.s3control.model.OwnerOverride.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.OwnerOverride.DESTINATION =>
      val r = Destination
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.OwnerOverride {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.OwnerOverride =
      software.amazon.awssdk.services.s3control.model.OwnerOverride.UNKNOWN_TO_SDK_VERSION
  }
  case object Destination extends zio.aws.s3control.model.OwnerOverride {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.OwnerOverride =
      software.amazon.awssdk.services.s3control.model.OwnerOverride.DESTINATION
  }
}
