package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.IsEnabled
import scala.jdk.CollectionConverters._
final case class AdvancedCostOptimizationMetrics(
    isEnabled: Optional[IsEnabled] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.AdvancedCostOptimizationMetrics = {
    import AdvancedCostOptimizationMetrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.AdvancedCostOptimizationMetrics
      .builder()
      .optionallyWith(
        isEnabled.map(value => IsEnabled.unwrap(value): java.lang.Boolean)
      )(_.isEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.AdvancedCostOptimizationMetrics.ReadOnly =
    zio.aws.s3control.model.AdvancedCostOptimizationMetrics
      .wrap(buildAwsValue())
}
object AdvancedCostOptimizationMetrics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.AdvancedCostOptimizationMetrics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.AdvancedCostOptimizationMetrics =
      zio.aws.s3control.model
        .AdvancedCostOptimizationMetrics(isEnabled.map(value => value))
    def isEnabled: Optional[IsEnabled]
    def getIsEnabled: ZIO[Any, AwsError, IsEnabled] =
      AwsError.unwrapOptionField("isEnabled", isEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.AdvancedCostOptimizationMetrics
  ) extends zio.aws.s3control.model.AdvancedCostOptimizationMetrics.ReadOnly {
    override val isEnabled: Optional[IsEnabled] = zio.aws.core.internal
      .optionalFromNullable(impl.isEnabled())
      .map(value => zio.aws.s3control.model.primitives.IsEnabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.AdvancedCostOptimizationMetrics
  ): zio.aws.s3control.model.AdvancedCostOptimizationMetrics.ReadOnly =
    new Wrapper(impl)
}
