package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BucketLevel(
    activityMetrics: Optional[zio.aws.s3control.model.ActivityMetrics] =
      Optional.Absent,
    prefixLevel: Optional[zio.aws.s3control.model.PrefixLevel] =
      Optional.Absent,
    advancedCostOptimizationMetrics: Optional[
      zio.aws.s3control.model.AdvancedCostOptimizationMetrics
    ] = Optional.Absent,
    advancedDataProtectionMetrics: Optional[
      zio.aws.s3control.model.AdvancedDataProtectionMetrics
    ] = Optional.Absent,
    detailedStatusCodesMetrics: Optional[
      zio.aws.s3control.model.DetailedStatusCodesMetrics
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.BucketLevel = {
    import BucketLevel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.BucketLevel
      .builder()
      .optionallyWith(activityMetrics.map(value => value.buildAwsValue()))(
        _.activityMetrics
      )
      .optionallyWith(prefixLevel.map(value => value.buildAwsValue()))(
        _.prefixLevel
      )
      .optionallyWith(
        advancedCostOptimizationMetrics.map(value => value.buildAwsValue())
      )(_.advancedCostOptimizationMetrics)
      .optionallyWith(
        advancedDataProtectionMetrics.map(value => value.buildAwsValue())
      )(_.advancedDataProtectionMetrics)
      .optionallyWith(
        detailedStatusCodesMetrics.map(value => value.buildAwsValue())
      )(_.detailedStatusCodesMetrics)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.BucketLevel.ReadOnly =
    zio.aws.s3control.model.BucketLevel.wrap(buildAwsValue())
}
object BucketLevel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.BucketLevel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.BucketLevel =
      zio.aws.s3control.model.BucketLevel(
        activityMetrics.map(value => value.asEditable),
        prefixLevel.map(value => value.asEditable),
        advancedCostOptimizationMetrics.map(value => value.asEditable),
        advancedDataProtectionMetrics.map(value => value.asEditable),
        detailedStatusCodesMetrics.map(value => value.asEditable)
      )
    def activityMetrics
        : Optional[zio.aws.s3control.model.ActivityMetrics.ReadOnly]
    def prefixLevel: Optional[zio.aws.s3control.model.PrefixLevel.ReadOnly]
    def advancedCostOptimizationMetrics: Optional[
      zio.aws.s3control.model.AdvancedCostOptimizationMetrics.ReadOnly
    ]
    def advancedDataProtectionMetrics: Optional[
      zio.aws.s3control.model.AdvancedDataProtectionMetrics.ReadOnly
    ]
    def detailedStatusCodesMetrics
        : Optional[zio.aws.s3control.model.DetailedStatusCodesMetrics.ReadOnly]
    def getActivityMetrics
        : ZIO[Any, AwsError, zio.aws.s3control.model.ActivityMetrics.ReadOnly] =
      AwsError.unwrapOptionField("activityMetrics", activityMetrics)
    def getPrefixLevel
        : ZIO[Any, AwsError, zio.aws.s3control.model.PrefixLevel.ReadOnly] =
      AwsError.unwrapOptionField("prefixLevel", prefixLevel)
    def getAdvancedCostOptimizationMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.AdvancedCostOptimizationMetrics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "advancedCostOptimizationMetrics",
      advancedCostOptimizationMetrics
    )
    def getAdvancedDataProtectionMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.AdvancedDataProtectionMetrics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "advancedDataProtectionMetrics",
      advancedDataProtectionMetrics
    )
    def getDetailedStatusCodesMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.DetailedStatusCodesMetrics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "detailedStatusCodesMetrics",
      detailedStatusCodesMetrics
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.BucketLevel
  ) extends zio.aws.s3control.model.BucketLevel.ReadOnly {
    override val activityMetrics
        : Optional[zio.aws.s3control.model.ActivityMetrics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activityMetrics())
        .map(value => zio.aws.s3control.model.ActivityMetrics.wrap(value))
    override val prefixLevel
        : Optional[zio.aws.s3control.model.PrefixLevel.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.prefixLevel())
        .map(value => zio.aws.s3control.model.PrefixLevel.wrap(value))
    override val advancedCostOptimizationMetrics: Optional[
      zio.aws.s3control.model.AdvancedCostOptimizationMetrics.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.advancedCostOptimizationMetrics())
      .map(value =>
        zio.aws.s3control.model.AdvancedCostOptimizationMetrics.wrap(value)
      )
    override val advancedDataProtectionMetrics: Optional[
      zio.aws.s3control.model.AdvancedDataProtectionMetrics.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.advancedDataProtectionMetrics())
      .map(value =>
        zio.aws.s3control.model.AdvancedDataProtectionMetrics.wrap(value)
      )
    override val detailedStatusCodesMetrics: Optional[
      zio.aws.s3control.model.DetailedStatusCodesMetrics.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.detailedStatusCodesMetrics())
      .map(value =>
        zio.aws.s3control.model.DetailedStatusCodesMetrics.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.BucketLevel
  ): zio.aws.s3control.model.BucketLevel.ReadOnly = new Wrapper(impl)
}
