package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.Prefix
import scala.jdk.CollectionConverters._
final case class ReplicationRuleFilter(
    prefix: Optional[Prefix] = Optional.Absent,
    tag: Optional[zio.aws.s3control.model.S3Tag] = Optional.Absent,
    and: Optional[zio.aws.s3control.model.ReplicationRuleAndOperator] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.ReplicationRuleFilter = {
    import ReplicationRuleFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.ReplicationRuleFilter
      .builder()
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(tag.map(value => value.buildAwsValue()))(_.tag)
      .optionallyWith(and.map(value => value.buildAwsValue()))(_.and)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.ReplicationRuleFilter.ReadOnly =
    zio.aws.s3control.model.ReplicationRuleFilter.wrap(buildAwsValue())
}
object ReplicationRuleFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.ReplicationRuleFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.ReplicationRuleFilter =
      zio.aws.s3control.model.ReplicationRuleFilter(
        prefix.map(value => value),
        tag.map(value => value.asEditable),
        and.map(value => value.asEditable)
      )
    def prefix: Optional[Prefix]
    def tag: Optional[zio.aws.s3control.model.S3Tag.ReadOnly]
    def and
        : Optional[zio.aws.s3control.model.ReplicationRuleAndOperator.ReadOnly]
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getTag: ZIO[Any, AwsError, zio.aws.s3control.model.S3Tag.ReadOnly] =
      AwsError.unwrapOptionField("tag", tag)
    def getAnd: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.ReplicationRuleAndOperator.ReadOnly
    ] = AwsError.unwrapOptionField("and", and)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.ReplicationRuleFilter
  ) extends zio.aws.s3control.model.ReplicationRuleFilter.ReadOnly {
    override val prefix: Optional[Prefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.s3control.model.primitives.Prefix(value))
    override val tag: Optional[zio.aws.s3control.model.S3Tag.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tag())
        .map(value => zio.aws.s3control.model.S3Tag.wrap(value))
    override val and: Optional[
      zio.aws.s3control.model.ReplicationRuleAndOperator.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.and())
      .map(value =>
        zio.aws.s3control.model.ReplicationRuleAndOperator.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.ReplicationRuleFilter
  ): zio.aws.s3control.model.ReplicationRuleFilter.ReadOnly = new Wrapper(impl)
}
