package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{AccountId, ConfigId}
import scala.jdk.CollectionConverters._
final case class DeleteStorageLensConfigurationTaggingRequest(
    configId: ConfigId,
    accountId: AccountId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationTaggingRequest = {
    import DeleteStorageLensConfigurationTaggingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationTaggingRequest
      .builder()
      .configId(ConfigId.unwrap(configId): java.lang.String)
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.DeleteStorageLensConfigurationTaggingRequest.ReadOnly =
    zio.aws.s3control.model.DeleteStorageLensConfigurationTaggingRequest
      .wrap(buildAwsValue())
}
object DeleteStorageLensConfigurationTaggingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationTaggingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.DeleteStorageLensConfigurationTaggingRequest =
      zio.aws.s3control.model
        .DeleteStorageLensConfigurationTaggingRequest(configId, accountId)
    def configId: ConfigId
    def accountId: AccountId
    def getConfigId: ZIO[Any, Nothing, ConfigId] = ZIO.succeed(configId)
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationTaggingRequest
  ) extends zio.aws.s3control.model.DeleteStorageLensConfigurationTaggingRequest.ReadOnly {
    override val configId: ConfigId =
      zio.aws.s3control.model.primitives.ConfigId(impl.configId())
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationTaggingRequest
  ): zio.aws.s3control.model.DeleteStorageLensConfigurationTaggingRequest.ReadOnly =
    new Wrapper(impl)
}
