package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{MultiRegionAccessPointId, AccountId}
import scala.jdk.CollectionConverters._
final case class SubmitMultiRegionAccessPointRoutesRequest(
    accountId: AccountId,
    mrap: MultiRegionAccessPointId,
    routeUpdates: Iterable[zio.aws.s3control.model.MultiRegionAccessPointRoute]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.SubmitMultiRegionAccessPointRoutesRequest = {
    import SubmitMultiRegionAccessPointRoutesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.SubmitMultiRegionAccessPointRoutesRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .mrap(MultiRegionAccessPointId.unwrap(mrap): java.lang.String)
      .routeUpdates(routeUpdates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.SubmitMultiRegionAccessPointRoutesRequest.ReadOnly =
    zio.aws.s3control.model.SubmitMultiRegionAccessPointRoutesRequest
      .wrap(buildAwsValue())
}
object SubmitMultiRegionAccessPointRoutesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.SubmitMultiRegionAccessPointRoutesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.SubmitMultiRegionAccessPointRoutesRequest =
      zio.aws.s3control.model.SubmitMultiRegionAccessPointRoutesRequest(
        accountId,
        mrap,
        routeUpdates.map { item =>
          item.asEditable
        }
      )
    def accountId: AccountId
    def mrap: MultiRegionAccessPointId
    def routeUpdates
        : List[zio.aws.s3control.model.MultiRegionAccessPointRoute.ReadOnly]
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getMrap: ZIO[Any, Nothing, MultiRegionAccessPointId] = ZIO.succeed(mrap)
    def getRouteUpdates: ZIO[Any, Nothing, List[
      zio.aws.s3control.model.MultiRegionAccessPointRoute.ReadOnly
    ]] = ZIO.succeed(routeUpdates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.SubmitMultiRegionAccessPointRoutesRequest
  ) extends zio.aws.s3control.model.SubmitMultiRegionAccessPointRoutesRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val mrap: MultiRegionAccessPointId =
      zio.aws.s3control.model.primitives.MultiRegionAccessPointId(impl.mrap())
    override val routeUpdates
        : List[zio.aws.s3control.model.MultiRegionAccessPointRoute.ReadOnly] =
      impl
        .routeUpdates()
        .asScala
        .map { item =>
          zio.aws.s3control.model.MultiRegionAccessPointRoute.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.SubmitMultiRegionAccessPointRoutesRequest
  ): zio.aws.s3control.model.SubmitMultiRegionAccessPointRoutesRequest.ReadOnly =
    new Wrapper(impl)
}
