package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{BucketName, AccountId}
import scala.jdk.CollectionConverters._
final case class DeleteBucketTaggingRequest(
    accountId: AccountId,
    bucket: BucketName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.DeleteBucketTaggingRequest = {
    import DeleteBucketTaggingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.DeleteBucketTaggingRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.DeleteBucketTaggingRequest.ReadOnly =
    zio.aws.s3control.model.DeleteBucketTaggingRequest.wrap(buildAwsValue())
}
object DeleteBucketTaggingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.DeleteBucketTaggingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.DeleteBucketTaggingRequest =
      zio.aws.s3control.model.DeleteBucketTaggingRequest(accountId, bucket)
    def accountId: AccountId
    def bucket: BucketName
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.DeleteBucketTaggingRequest
  ) extends zio.aws.s3control.model.DeleteBucketTaggingRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val bucket: BucketName =
      zio.aws.s3control.model.primitives.BucketName(impl.bucket())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.DeleteBucketTaggingRequest
  ): zio.aws.s3control.model.DeleteBucketTaggingRequest.ReadOnly = new Wrapper(
    impl
  )
}
