package zio.aws.s3control.model
import zio.aws.s3control.model.primitives.{
  MaxResults,
  StringForNextToken,
  AccountId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListJobsRequest(
    accountId: AccountId,
    jobStatuses: Optional[Iterable[zio.aws.s3control.model.JobStatus]] =
      Optional.Absent,
    nextToken: Optional[StringForNextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.ListJobsRequest = {
    import ListJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.ListJobsRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .optionallyWith(
        jobStatuses.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.jobStatusesWithStrings)
      .optionallyWith(
        nextToken.map(value =>
          StringForNextToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.ListJobsRequest.ReadOnly =
    zio.aws.s3control.model.ListJobsRequest.wrap(buildAwsValue())
}
object ListJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.ListJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.ListJobsRequest =
      zio.aws.s3control.model.ListJobsRequest(
        accountId,
        jobStatuses.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def accountId: AccountId
    def jobStatuses: Optional[List[zio.aws.s3control.model.JobStatus]]
    def nextToken: Optional[StringForNextToken]
    def maxResults: Optional[MaxResults]
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getJobStatuses
        : ZIO[Any, AwsError, List[zio.aws.s3control.model.JobStatus]] =
      AwsError.unwrapOptionField("jobStatuses", jobStatuses)
    def getNextToken: ZIO[Any, AwsError, StringForNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.ListJobsRequest
  ) extends zio.aws.s3control.model.ListJobsRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val jobStatuses
        : Optional[List[zio.aws.s3control.model.JobStatus]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobStatuses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3control.model.JobStatus.wrap(item)
          }.toList
        )
    override val nextToken: Optional[StringForNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.s3control.model.primitives.StringForNextToken(value)
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.s3control.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.ListJobsRequest
  ): zio.aws.s3control.model.ListJobsRequest.ReadOnly = new Wrapper(impl)
}
