package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AccountLevel(
    activityMetrics: Optional[zio.aws.s3control.model.ActivityMetrics] =
      Optional.Absent,
    bucketLevel: zio.aws.s3control.model.BucketLevel
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.AccountLevel = {
    import AccountLevel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.AccountLevel
      .builder()
      .optionallyWith(activityMetrics.map(value => value.buildAwsValue()))(
        _.activityMetrics
      )
      .bucketLevel(bucketLevel.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.AccountLevel.ReadOnly =
    zio.aws.s3control.model.AccountLevel.wrap(buildAwsValue())
}
object AccountLevel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.AccountLevel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.AccountLevel =
      zio.aws.s3control.model.AccountLevel(
        activityMetrics.map(value => value.asEditable),
        bucketLevel.asEditable
      )
    def activityMetrics
        : Optional[zio.aws.s3control.model.ActivityMetrics.ReadOnly]
    def bucketLevel: zio.aws.s3control.model.BucketLevel.ReadOnly
    def getActivityMetrics
        : ZIO[Any, AwsError, zio.aws.s3control.model.ActivityMetrics.ReadOnly] =
      AwsError.unwrapOptionField("activityMetrics", activityMetrics)
    def getBucketLevel
        : ZIO[Any, Nothing, zio.aws.s3control.model.BucketLevel.ReadOnly] =
      ZIO.succeed(bucketLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.AccountLevel
  ) extends zio.aws.s3control.model.AccountLevel.ReadOnly {
    override val activityMetrics
        : Optional[zio.aws.s3control.model.ActivityMetrics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activityMetrics())
        .map(value => zio.aws.s3control.model.ActivityMetrics.wrap(value))
    override val bucketLevel: zio.aws.s3control.model.BucketLevel.ReadOnly =
      zio.aws.s3control.model.BucketLevel.wrap(impl.bucketLevel())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.AccountLevel
  ): zio.aws.s3control.model.AccountLevel.ReadOnly = new Wrapper(impl)
}
