package zio.aws.s3control.model
import zio.aws.s3control.model.primitives.ObjectCreationTime
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class JobManifestGeneratorFilter(
    eligibleForReplication: Optional[Boolean] = Optional.Absent,
    createdAfter: Optional[ObjectCreationTime] = Optional.Absent,
    createdBefore: Optional[ObjectCreationTime] = Optional.Absent,
    objectReplicationStatuses: Optional[
      Iterable[zio.aws.s3control.model.ReplicationStatus]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.JobManifestGeneratorFilter = {
    import JobManifestGeneratorFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.JobManifestGeneratorFilter
      .builder()
      .optionallyWith(
        eligibleForReplication.map(value => value: java.lang.Boolean)
      )(_.eligibleForReplication)
      .optionallyWith(
        createdAfter.map(value => ObjectCreationTime.unwrap(value): Instant)
      )(_.createdAfter)
      .optionallyWith(
        createdBefore.map(value => ObjectCreationTime.unwrap(value): Instant)
      )(_.createdBefore)
      .optionallyWith(
        objectReplicationStatuses.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.objectReplicationStatusesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.JobManifestGeneratorFilter.ReadOnly =
    zio.aws.s3control.model.JobManifestGeneratorFilter.wrap(buildAwsValue())
}
object JobManifestGeneratorFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.JobManifestGeneratorFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.JobManifestGeneratorFilter =
      zio.aws.s3control.model.JobManifestGeneratorFilter(
        eligibleForReplication.map(value => value),
        createdAfter.map(value => value),
        createdBefore.map(value => value),
        objectReplicationStatuses.map(value => value)
      )
    def eligibleForReplication: Optional[Boolean]
    def createdAfter: Optional[ObjectCreationTime]
    def createdBefore: Optional[ObjectCreationTime]
    def objectReplicationStatuses
        : Optional[List[zio.aws.s3control.model.ReplicationStatus]]
    def getEligibleForReplication: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("eligibleForReplication", eligibleForReplication)
    def getCreatedAfter: ZIO[Any, AwsError, ObjectCreationTime] =
      AwsError.unwrapOptionField("createdAfter", createdAfter)
    def getCreatedBefore: ZIO[Any, AwsError, ObjectCreationTime] =
      AwsError.unwrapOptionField("createdBefore", createdBefore)
    def getObjectReplicationStatuses
        : ZIO[Any, AwsError, List[zio.aws.s3control.model.ReplicationStatus]] =
      AwsError.unwrapOptionField(
        "objectReplicationStatuses",
        objectReplicationStatuses
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.JobManifestGeneratorFilter
  ) extends zio.aws.s3control.model.JobManifestGeneratorFilter.ReadOnly {
    override val eligibleForReplication: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eligibleForReplication())
        .map(value => value: Boolean)
    override val createdAfter: Optional[ObjectCreationTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdAfter())
        .map(value =>
          zio.aws.s3control.model.primitives.ObjectCreationTime(value)
        )
    override val createdBefore: Optional[ObjectCreationTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBefore())
        .map(value =>
          zio.aws.s3control.model.primitives.ObjectCreationTime(value)
        )
    override val objectReplicationStatuses
        : Optional[List[zio.aws.s3control.model.ReplicationStatus]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectReplicationStatuses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3control.model.ReplicationStatus.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.JobManifestGeneratorFilter
  ): zio.aws.s3control.model.JobManifestGeneratorFilter.ReadOnly = new Wrapper(
    impl
  )
}
